@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * NAT rule collection resource.
 * @property action The action type of a NAT rule collection.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
 * @property priority Priority of the NAT rule collection resource.
 * @property rules Collection of rules used by a NAT rule collection.
 */
public data class AzureFirewallNatRuleCollectionArgs(
    public val action: Output<AzureFirewallNatRCActionArgs>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val rules: Output<List<AzureFirewallNatRuleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleCollectionArgs =
        com.pulumi.azurenative.network.inputs.AzureFirewallNatRuleCollectionArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .rules(
                rules?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [AzureFirewallNatRuleCollectionArgs].
 */
@PulumiTagMarker
public class AzureFirewallNatRuleCollectionArgsBuilder internal constructor() {
    private var action: Output<AzureFirewallNatRCActionArgs>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var rules: Output<List<AzureFirewallNatRuleArgs>>? = null

    /**
     * @param value The action type of a NAT rule collection.
     */
    @JvmName("ekmtjhcmfeaqfyrm")
    public suspend fun action(`value`: Output<AzureFirewallNatRCActionArgs>) {
        this.action = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("wxtfuuedhetjndfv")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
     */
    @JvmName("djposyrrxqewkssl")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the NAT rule collection resource.
     */
    @JvmName("vcsecibrhiajbjlg")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value Collection of rules used by a NAT rule collection.
     */
    @JvmName("cwimpytnxojbqcap")
    public suspend fun rules(`value`: Output<List<AzureFirewallNatRuleArgs>>) {
        this.rules = value
    }

    @JvmName("rqvaobpxcirhxnai")
    public suspend fun rules(vararg values: Output<AzureFirewallNatRuleArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values Collection of rules used by a NAT rule collection.
     */
    @JvmName("vdysiujevbqoondu")
    public suspend fun rules(values: List<Output<AzureFirewallNatRuleArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The action type of a NAT rule collection.
     */
    @JvmName("xedgytotyvvyrppt")
    public suspend fun action(`value`: AzureFirewallNatRCActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a NAT rule collection.
     */
    @JvmName("jlmmukepvsnfkdnq")
    public suspend fun action(argument: suspend AzureFirewallNatRCActionArgsBuilder.() -> Unit) {
        val toBeMapped = AzureFirewallNatRCActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("qgbjooxlbukbhwis")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within the Azure firewall. This name can be used to access the resource.
     */
    @JvmName("uoujaneajyssxcwg")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the NAT rule collection resource.
     */
    @JvmName("dgofrgwgvtdovhhr")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value Collection of rules used by a NAT rule collection.
     */
    @JvmName("wpbhqlwkcranvfat")
    public suspend fun rules(`value`: List<AzureFirewallNatRuleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a NAT rule collection.
     */
    @JvmName("mumhudyocqcwuhgp")
    public suspend fun rules(argument: List<suspend AzureFirewallNatRuleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a NAT rule collection.
     */
    @JvmName("disliqihnlybmyhn")
    public suspend fun rules(vararg argument: suspend AzureFirewallNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            AzureFirewallNatRuleArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument Collection of rules used by a NAT rule collection.
     */
    @JvmName("rltswqcswbweexxj")
    public suspend fun rules(argument: suspend AzureFirewallNatRuleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(AzureFirewallNatRuleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values Collection of rules used by a NAT rule collection.
     */
    @JvmName("suxkopvkujcerrck")
    public suspend fun rules(vararg values: AzureFirewallNatRuleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): AzureFirewallNatRuleCollectionArgs = AzureFirewallNatRuleCollectionArgs(
        action = action,
        id = id,
        name = name,
        priority = priority,
        rules = rules,
    )
}
