@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CnameRecordArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A CNAME record.
 * @property cname The canonical name for this CNAME record.
 */
public data class CnameRecordArgs(
    public val cname: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CnameRecordArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CnameRecordArgs =
        com.pulumi.azurenative.network.inputs.CnameRecordArgs.builder()
            .cname(cname?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CnameRecordArgs].
 */
@PulumiTagMarker
public class CnameRecordArgsBuilder internal constructor() {
    private var cname: Output<String>? = null

    /**
     * @param value The canonical name for this CNAME record.
     */
    @JvmName("ykjryoocqkbvdcax")
    public suspend fun cname(`value`: Output<String>) {
        this.cname = value
    }

    /**
     * @param value The canonical name for this CNAME record.
     */
    @JvmName("yjtwbnswfhrksjuc")
    public suspend fun cname(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cname = mapped
    }

    internal fun build(): CnameRecordArgs = CnameRecordArgs(
        cname = cname,
    )
}
