@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterItemArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ConnectionMonitorEndpointFilterItemType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the connection monitor endpoint filter item.
 * @property address The address of the filter item.
 * @property type The type of item included in the filter. Currently only 'AgentAddress' is supported.
 */
public data class ConnectionMonitorEndpointFilterItemArgs(
    public val address: Output<String>? = null,
    public val type: Output<Either<String, ConnectionMonitorEndpointFilterItemType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterItemArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterItemArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorEndpointFilterItemArgs.builder()
            .address(address?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorEndpointFilterItemArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorEndpointFilterItemArgsBuilder internal constructor() {
    private var address: Output<String>? = null

    private var type: Output<Either<String, ConnectionMonitorEndpointFilterItemType>>? = null

    /**
     * @param value The address of the filter item.
     */
    @JvmName("tsjvtvbochvbgqoh")
    public suspend fun address(`value`: Output<String>) {
        this.address = value
    }

    /**
     * @param value The type of item included in the filter. Currently only 'AgentAddress' is supported.
     */
    @JvmName("fchvmckdrqtqidba")
    public suspend fun type(`value`: Output<Either<String, ConnectionMonitorEndpointFilterItemType>>) {
        this.type = value
    }

    /**
     * @param value The address of the filter item.
     */
    @JvmName("rkqreymjijetkhlt")
    public suspend fun address(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.address = mapped
    }

    /**
     * @param value The type of item included in the filter. Currently only 'AgentAddress' is supported.
     */
    @JvmName("wlhsagikleksogod")
    public suspend fun type(`value`: Either<String, ConnectionMonitorEndpointFilterItemType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of item included in the filter. Currently only 'AgentAddress' is supported.
     */
    @JvmName("oestpmymwplejsht")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ConnectionMonitorEndpointFilterItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of item included in the filter. Currently only 'AgentAddress' is supported.
     */
    @JvmName("rbfyglbijdwxmgei")
    public fun type(`value`: ConnectionMonitorEndpointFilterItemType) {
        val toBeMapped = Either.ofRight<String, ConnectionMonitorEndpointFilterItemType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ConnectionMonitorEndpointFilterItemArgs =
        ConnectionMonitorEndpointFilterItemArgs(
            address = address,
            type = type,
        )
}
