@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorOutputArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.OutputType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Describes a connection monitor output destination.
 * @property type Connection monitor output destination type. Currently, only "Workspace" is supported.
 * @property workspaceSettings Describes the settings for producing output into a log analytics workspace.
 */
public data class ConnectionMonitorOutputArgs(
    public val type: Output<Either<String, OutputType>>? = null,
    public val workspaceSettings: Output<ConnectionMonitorWorkspaceSettingsArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorOutputArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorOutputArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorOutputArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .workspaceSettings(
                workspaceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ConnectionMonitorOutputArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorOutputArgsBuilder internal constructor() {
    private var type: Output<Either<String, OutputType>>? = null

    private var workspaceSettings: Output<ConnectionMonitorWorkspaceSettingsArgs>? = null

    /**
     * @param value Connection monitor output destination type. Currently, only "Workspace" is supported.
     */
    @JvmName("xkuheiyaoxiuxevb")
    public suspend fun type(`value`: Output<Either<String, OutputType>>) {
        this.type = value
    }

    /**
     * @param value Describes the settings for producing output into a log analytics workspace.
     */
    @JvmName("aketbiyixmtqhaej")
    public suspend fun workspaceSettings(`value`: Output<ConnectionMonitorWorkspaceSettingsArgs>) {
        this.workspaceSettings = value
    }

    /**
     * @param value Connection monitor output destination type. Currently, only "Workspace" is supported.
     */
    @JvmName("xujrnsvfdhvqicjg")
    public suspend fun type(`value`: Either<String, OutputType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Connection monitor output destination type. Currently, only "Workspace" is supported.
     */
    @JvmName("edayfkntpabvshbd")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, OutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Connection monitor output destination type. Currently, only "Workspace" is supported.
     */
    @JvmName("dkbofsijisnnakfk")
    public fun type(`value`: OutputType) {
        val toBeMapped = Either.ofRight<String, OutputType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Describes the settings for producing output into a log analytics workspace.
     */
    @JvmName("fbfisrvweidumaqw")
    public suspend fun workspaceSettings(`value`: ConnectionMonitorWorkspaceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceSettings = mapped
    }

    /**
     * @param argument Describes the settings for producing output into a log analytics workspace.
     */
    @JvmName("behmaxreecttbxdf")
    public suspend fun workspaceSettings(argument: suspend ConnectionMonitorWorkspaceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ConnectionMonitorWorkspaceSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.workspaceSettings = mapped
    }

    internal fun build(): ConnectionMonitorOutputArgs = ConnectionMonitorOutputArgs(
        type = type,
        workspaceSettings = workspaceSettings,
    )
}
