@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorSuccessThresholdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the threshold for declaring a test successful.
 * @property checksFailedPercent The maximum percentage of failed checks permitted for a test to evaluate as successful.
 * @property roundTripTimeMs The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
 */
public data class ConnectionMonitorSuccessThresholdArgs(
    public val checksFailedPercent: Output<Int>? = null,
    public val roundTripTimeMs: Output<Double>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorSuccessThresholdArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorSuccessThresholdArgs = com.pulumi.azurenative.network.inputs.ConnectionMonitorSuccessThresholdArgs.builder()
        .checksFailedPercent(checksFailedPercent?.applyValue({ args0 -> args0 }))
        .roundTripTimeMs(roundTripTimeMs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorSuccessThresholdArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorSuccessThresholdArgsBuilder internal constructor() {
    private var checksFailedPercent: Output<Int>? = null

    private var roundTripTimeMs: Output<Double>? = null

    /**
     * @param value The maximum percentage of failed checks permitted for a test to evaluate as successful.
     */
    @JvmName("ihqkgfusnnujpqpr")
    public suspend fun checksFailedPercent(`value`: Output<Int>) {
        this.checksFailedPercent = value
    }

    /**
     * @param value The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
     */
    @JvmName("ovufqoralwcairnc")
    public suspend fun roundTripTimeMs(`value`: Output<Double>) {
        this.roundTripTimeMs = value
    }

    /**
     * @param value The maximum percentage of failed checks permitted for a test to evaluate as successful.
     */
    @JvmName("hxyxrcwtvxbsoknk")
    public suspend fun checksFailedPercent(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.checksFailedPercent = mapped
    }

    /**
     * @param value The maximum round-trip time in milliseconds permitted for a test to evaluate as successful.
     */
    @JvmName("fpbvwhkyiscrkviq")
    public suspend fun roundTripTimeMs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roundTripTimeMs = mapped
    }

    internal fun build(): ConnectionMonitorSuccessThresholdArgs =
        ConnectionMonitorSuccessThresholdArgs(
            checksFailedPercent = checksFailedPercent,
            roundTripTimeMs = roundTripTimeMs,
        )
}
