@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ConnectionMonitorWorkspaceSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Describes the settings for producing output into a log analytics workspace.
 * @property workspaceResourceId Log analytics workspace resource ID.
 */
public data class ConnectionMonitorWorkspaceSettingsArgs(
    public val workspaceResourceId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ConnectionMonitorWorkspaceSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ConnectionMonitorWorkspaceSettingsArgs =
        com.pulumi.azurenative.network.inputs.ConnectionMonitorWorkspaceSettingsArgs.builder()
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ConnectionMonitorWorkspaceSettingsArgs].
 */
@PulumiTagMarker
public class ConnectionMonitorWorkspaceSettingsArgsBuilder internal constructor() {
    private var workspaceResourceId: Output<String>? = null

    /**
     * @param value Log analytics workspace resource ID.
     */
    @JvmName("drpeuxbtnubpwrwi")
    public suspend fun workspaceResourceId(`value`: Output<String>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value Log analytics workspace resource ID.
     */
    @JvmName("rgrfynlaffqpxcas")
    public suspend fun workspaceResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): ConnectionMonitorWorkspaceSettingsArgs =
        ConnectionMonitorWorkspaceSettingsArgs(
            workspaceResourceId = workspaceResourceId,
        )
}
