@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.CriterionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.RouteMapMatchCondition
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A matching criteria which matches routes based on route prefix, community, and AS path.
 * @property asPath List of AS paths which this criteria matches.
 * @property community List of BGP communities which this criteria matches.
 * @property matchCondition Match condition to apply RouteMap rules.
 * @property routePrefix List of route prefixes which this criteria matches.
 */
public data class CriterionArgs(
    public val asPath: Output<List<String>>? = null,
    public val community: Output<List<String>>? = null,
    public val matchCondition: Output<Either<String, RouteMapMatchCondition>>? = null,
    public val routePrefix: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.CriterionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.CriterionArgs =
        com.pulumi.azurenative.network.inputs.CriterionArgs.builder()
            .asPath(asPath?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .community(community?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .matchCondition(
                matchCondition?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .routePrefix(routePrefix?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [CriterionArgs].
 */
@PulumiTagMarker
public class CriterionArgsBuilder internal constructor() {
    private var asPath: Output<List<String>>? = null

    private var community: Output<List<String>>? = null

    private var matchCondition: Output<Either<String, RouteMapMatchCondition>>? = null

    private var routePrefix: Output<List<String>>? = null

    /**
     * @param value List of AS paths which this criteria matches.
     */
    @JvmName("ykkucwrdtdhcggce")
    public suspend fun asPath(`value`: Output<List<String>>) {
        this.asPath = value
    }

    @JvmName("cgufyprgjmmtxyrb")
    public suspend fun asPath(vararg values: Output<String>) {
        this.asPath = Output.all(values.asList())
    }

    /**
     * @param values List of AS paths which this criteria matches.
     */
    @JvmName("wtroddcajrmvitye")
    public suspend fun asPath(values: List<Output<String>>) {
        this.asPath = Output.all(values)
    }

    /**
     * @param value List of BGP communities which this criteria matches.
     */
    @JvmName("meeemnwbnfedhkhb")
    public suspend fun community(`value`: Output<List<String>>) {
        this.community = value
    }

    @JvmName("wgbpxnpppnvcdnwq")
    public suspend fun community(vararg values: Output<String>) {
        this.community = Output.all(values.asList())
    }

    /**
     * @param values List of BGP communities which this criteria matches.
     */
    @JvmName("mgrgkvqyqeahnhgj")
    public suspend fun community(values: List<Output<String>>) {
        this.community = Output.all(values)
    }

    /**
     * @param value Match condition to apply RouteMap rules.
     */
    @JvmName("abdslfvoxbmpqupv")
    public suspend fun matchCondition(`value`: Output<Either<String, RouteMapMatchCondition>>) {
        this.matchCondition = value
    }

    /**
     * @param value List of route prefixes which this criteria matches.
     */
    @JvmName("wcfuvhgvadxocttj")
    public suspend fun routePrefix(`value`: Output<List<String>>) {
        this.routePrefix = value
    }

    @JvmName("gplhouybaduibwec")
    public suspend fun routePrefix(vararg values: Output<String>) {
        this.routePrefix = Output.all(values.asList())
    }

    /**
     * @param values List of route prefixes which this criteria matches.
     */
    @JvmName("gonslosvdvldbssr")
    public suspend fun routePrefix(values: List<Output<String>>) {
        this.routePrefix = Output.all(values)
    }

    /**
     * @param value List of AS paths which this criteria matches.
     */
    @JvmName("srppmeyydquwgydh")
    public suspend fun asPath(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.asPath = mapped
    }

    /**
     * @param values List of AS paths which this criteria matches.
     */
    @JvmName("avnfdcrhmsmjhqst")
    public suspend fun asPath(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.asPath = mapped
    }

    /**
     * @param value List of BGP communities which this criteria matches.
     */
    @JvmName("xsicblrurdvaiajf")
    public suspend fun community(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.community = mapped
    }

    /**
     * @param values List of BGP communities which this criteria matches.
     */
    @JvmName("hnbhnklrkdhlespi")
    public suspend fun community(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.community = mapped
    }

    /**
     * @param value Match condition to apply RouteMap rules.
     */
    @JvmName("nubkakujeqpbnlly")
    public suspend fun matchCondition(`value`: Either<String, RouteMapMatchCondition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.matchCondition = mapped
    }

    /**
     * @param value Match condition to apply RouteMap rules.
     */
    @JvmName("oqcnildbscxeitov")
    public fun matchCondition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, RouteMapMatchCondition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchCondition = mapped
    }

    /**
     * @param value Match condition to apply RouteMap rules.
     */
    @JvmName("pupvpgwsjcrjqtlv")
    public fun matchCondition(`value`: RouteMapMatchCondition) {
        val toBeMapped = Either.ofRight<String, RouteMapMatchCondition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.matchCondition = mapped
    }

    /**
     * @param value List of route prefixes which this criteria matches.
     */
    @JvmName("csobqxwornrpnesp")
    public suspend fun routePrefix(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routePrefix = mapped
    }

    /**
     * @param values List of route prefixes which this criteria matches.
     */
    @JvmName("ubkfclmybelifqff")
    public suspend fun routePrefix(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.routePrefix = mapped
    }

    internal fun build(): CriterionArgs = CriterionArgs(
        asPath = asPath,
        community = community,
        matchCondition = matchCondition,
        routePrefix = routePrefix,
    )
}
