@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.DdosSettingsArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.DdosSettingsProtectionMode
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Contains the DDoS protection settings of the public IP.
 * @property ddosProtectionPlan The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
 * @property protectionMode The DDoS protection mode of the public IP
 */
public data class DdosSettingsArgs(
    public val ddosProtectionPlan: Output<SubResourceArgs>? = null,
    public val protectionMode: Output<Either<String, DdosSettingsProtectionMode>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.DdosSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.DdosSettingsArgs =
        com.pulumi.azurenative.network.inputs.DdosSettingsArgs.builder()
            .ddosProtectionPlan(
                ddosProtectionPlan?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .protectionMode(
                protectionMode?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [DdosSettingsArgs].
 */
@PulumiTagMarker
public class DdosSettingsArgsBuilder internal constructor() {
    private var ddosProtectionPlan: Output<SubResourceArgs>? = null

    private var protectionMode: Output<Either<String, DdosSettingsProtectionMode>>? = null

    /**
     * @param value The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
     */
    @JvmName("xemshqywnlrwurrv")
    public suspend fun ddosProtectionPlan(`value`: Output<SubResourceArgs>) {
        this.ddosProtectionPlan = value
    }

    /**
     * @param value The DDoS protection mode of the public IP
     */
    @JvmName("nffsrucnghtixguo")
    public suspend fun protectionMode(`value`: Output<Either<String, DdosSettingsProtectionMode>>) {
        this.protectionMode = value
    }

    /**
     * @param value The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
     */
    @JvmName("setcrimychyrtucu")
    public suspend fun ddosProtectionPlan(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ddosProtectionPlan = mapped
    }

    /**
     * @param argument The DDoS protection plan associated with the public IP. Can only be set if ProtectionMode is Enabled
     */
    @JvmName("wkuhkkdsaxqvovfb")
    public suspend fun ddosProtectionPlan(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.ddosProtectionPlan = mapped
    }

    /**
     * @param value The DDoS protection mode of the public IP
     */
    @JvmName("aoxpdoxdqqgbngmf")
    public suspend fun protectionMode(`value`: Either<String, DdosSettingsProtectionMode>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.protectionMode = mapped
    }

    /**
     * @param value The DDoS protection mode of the public IP
     */
    @JvmName("hltqkntjknfjucyq")
    public fun protectionMode(`value`: String) {
        val toBeMapped = Either.ofLeft<String, DdosSettingsProtectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionMode = mapped
    }

    /**
     * @param value The DDoS protection mode of the public IP
     */
    @JvmName("ugwpjopqrustuvyk")
    public fun protectionMode(`value`: DdosSettingsProtectionMode) {
        val toBeMapped = Either.ofRight<String, DdosSettingsProtectionMode>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.protectionMode = mapped
    }

    internal fun build(): DdosSettingsArgs = DdosSettingsArgs(
        ddosProtectionPlan = ddosProtectionPlan,
        protectionMode = protectionMode,
    )
}
