@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.DelegationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the delegation.
 * @property serviceName The service name to which the NVA is delegated.
 */
public data class DelegationPropertiesArgs(
    public val serviceName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.DelegationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.DelegationPropertiesArgs =
        com.pulumi.azurenative.network.inputs.DelegationPropertiesArgs.builder()
            .serviceName(serviceName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DelegationPropertiesArgs].
 */
@PulumiTagMarker
public class DelegationPropertiesArgsBuilder internal constructor() {
    private var serviceName: Output<String>? = null

    /**
     * @param value The service name to which the NVA is delegated.
     */
    @JvmName("jqdwpmrkryscsywj")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The service name to which the NVA is delegated.
     */
    @JvmName("csoxuaytflktmnsh")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    internal fun build(): DelegationPropertiesArgs = DelegationPropertiesArgs(
        serviceName = serviceName,
    )
}
