@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExclusionManagedRuleSetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule set for Exclusions.
 * @property ruleGroups Defines the rule groups to apply to the rule set.
 * @property ruleSetType Defines the rule set type to use.
 * @property ruleSetVersion Defines the version of the rule set to use.
 */
public data class ExclusionManagedRuleSetArgs(
    public val ruleGroups: Output<List<ExclusionManagedRuleGroupArgs>>? = null,
    public val ruleSetType: Output<String>,
    public val ruleSetVersion: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExclusionManagedRuleSetArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExclusionManagedRuleSetArgs =
        com.pulumi.azurenative.network.inputs.ExclusionManagedRuleSetArgs.builder()
            .ruleGroups(
                ruleGroups?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleSetType(ruleSetType.applyValue({ args0 -> args0 }))
            .ruleSetVersion(ruleSetVersion.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExclusionManagedRuleSetArgs].
 */
@PulumiTagMarker
public class ExclusionManagedRuleSetArgsBuilder internal constructor() {
    private var ruleGroups: Output<List<ExclusionManagedRuleGroupArgs>>? = null

    private var ruleSetType: Output<String>? = null

    private var ruleSetVersion: Output<String>? = null

    /**
     * @param value Defines the rule groups to apply to the rule set.
     */
    @JvmName("hyepgjwhbtypmlbk")
    public suspend fun ruleGroups(`value`: Output<List<ExclusionManagedRuleGroupArgs>>) {
        this.ruleGroups = value
    }

    @JvmName("ikgehilmkhkaufqk")
    public suspend fun ruleGroups(vararg values: Output<ExclusionManagedRuleGroupArgs>) {
        this.ruleGroups = Output.all(values.asList())
    }

    /**
     * @param values Defines the rule groups to apply to the rule set.
     */
    @JvmName("fyjljikbvrknmpek")
    public suspend fun ruleGroups(values: List<Output<ExclusionManagedRuleGroupArgs>>) {
        this.ruleGroups = Output.all(values)
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("hnuvojolwxniuxyu")
    public suspend fun ruleSetType(`value`: Output<String>) {
        this.ruleSetType = value
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("alogksmpkmjmhuri")
    public suspend fun ruleSetVersion(`value`: Output<String>) {
        this.ruleSetVersion = value
    }

    /**
     * @param value Defines the rule groups to apply to the rule set.
     */
    @JvmName("gxigkkdmwpvfxipk")
    public suspend fun ruleGroups(`value`: List<ExclusionManagedRuleGroupArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleGroups = mapped
    }

    /**
     * @param argument Defines the rule groups to apply to the rule set.
     */
    @JvmName("xuuegpydwwulwjyt")
    public suspend fun ruleGroups(argument: List<suspend ExclusionManagedRuleGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ExclusionManagedRuleGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroups = mapped
    }

    /**
     * @param argument Defines the rule groups to apply to the rule set.
     */
    @JvmName("xbltqmaovpgrhdjw")
    public suspend fun ruleGroups(vararg argument: suspend ExclusionManagedRuleGroupArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ExclusionManagedRuleGroupArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.ruleGroups = mapped
    }

    /**
     * @param argument Defines the rule groups to apply to the rule set.
     */
    @JvmName("enwjqqhqrrsmanep")
    public suspend fun ruleGroups(argument: suspend ExclusionManagedRuleGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ExclusionManagedRuleGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.ruleGroups = mapped
    }

    /**
     * @param values Defines the rule groups to apply to the rule set.
     */
    @JvmName("wgcadvlqvjxkkvxc")
    public suspend fun ruleGroups(vararg values: ExclusionManagedRuleGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroups = mapped
    }

    /**
     * @param value Defines the rule set type to use.
     */
    @JvmName("mhnvqcyakhbdldoo")
    public suspend fun ruleSetType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetType = mapped
    }

    /**
     * @param value Defines the version of the rule set to use.
     */
    @JvmName("xuctutwnhcdihwkj")
    public suspend fun ruleSetVersion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleSetVersion = mapped
    }

    internal fun build(): ExclusionManagedRuleSetArgs = ExclusionManagedRuleSetArgs(
        ruleGroups = ruleGroups,
        ruleSetType = ruleSetType ?: throw PulumiNullFieldException("ruleSetType"),
        ruleSetVersion = ruleSetVersion ?: throw PulumiNullFieldException("ruleSetVersion"),
    )
}
