@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitAuthorizationArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.AuthorizationUseStatus
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Authorization in an ExpressRouteCircuit resource.
 * @property authorizationKey The authorization key.
 * @property authorizationUseStatus The authorization use status.
 * @property id Resource ID.
 * @property name The name of the resource that is unique within a resource group. This name can be used to access the resource.
 */
public data class ExpressRouteCircuitAuthorizationArgs(
    public val authorizationKey: Output<String>? = null,
    public val authorizationUseStatus: Output<Either<String, AuthorizationUseStatus>>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitAuthorizationArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitAuthorizationArgs = com.pulumi.azurenative.network.inputs.ExpressRouteCircuitAuthorizationArgs.builder()
        .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
        .authorizationUseStatus(
            authorizationUseStatus?.applyValue({ args0 ->
                args0.transform({ args0 ->
                    args0
                }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
            }),
        )
        .id(id?.applyValue({ args0 -> args0 }))
        .name(name?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitAuthorizationArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitAuthorizationArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var authorizationUseStatus: Output<Either<String, AuthorizationUseStatus>>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    /**
     * @param value The authorization key.
     */
    @JvmName("etmqitfqsivkpgvp")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("cktfwgjiuqeclbyw")
    public suspend fun authorizationUseStatus(`value`: Output<Either<String, AuthorizationUseStatus>>) {
        this.authorizationUseStatus = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("ggvmumxdyhpjqgmu")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("llwcutlrycubyxad")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The authorization key.
     */
    @JvmName("jpddkskrlxcloeqc")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("kssikpagltqxsjys")
    public suspend fun authorizationUseStatus(`value`: Either<String, AuthorizationUseStatus>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationUseStatus = mapped
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("aywhwplqdciethbe")
    public fun authorizationUseStatus(`value`: String) {
        val toBeMapped = Either.ofLeft<String, AuthorizationUseStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationUseStatus = mapped
    }

    /**
     * @param value The authorization use status.
     */
    @JvmName("jnyqloriypwftgjd")
    public fun authorizationUseStatus(`value`: AuthorizationUseStatus) {
        val toBeMapped = Either.ofRight<String, AuthorizationUseStatus>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authorizationUseStatus = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("yesxlwbrwdukibjw")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource that is unique within a resource group. This name can be used to access the resource.
     */
    @JvmName("cqvcdfneeollfadp")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    internal fun build(): ExpressRouteCircuitAuthorizationArgs = ExpressRouteCircuitAuthorizationArgs(
        authorizationKey = authorizationKey,
        authorizationUseStatus = authorizationUseStatus,
        id = id,
        name = name,
    )
}
