@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Specifies the peering configuration.
 * @property advertisedCommunities The communities of bgp peering. Specified for microsoft peering.
 * @property advertisedPublicPrefixes The reference to AdvertisedPublicPrefixes.
 * @property customerASN The CustomerASN of the peering.
 * @property legacyMode The legacy mode of the peering.
 * @property routingRegistryName The RoutingRegistryName of the configuration.
 */
public data class ExpressRouteCircuitPeeringConfigArgs(
    public val advertisedCommunities: Output<List<String>>? = null,
    public val advertisedPublicPrefixes: Output<List<String>>? = null,
    public val customerASN: Output<Int>? = null,
    public val legacyMode: Output<Int>? = null,
    public val routingRegistryName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringConfigArgs = com.pulumi.azurenative.network.inputs.ExpressRouteCircuitPeeringConfigArgs.builder()
        .advertisedCommunities(advertisedCommunities?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
        .advertisedPublicPrefixes(
            advertisedPublicPrefixes?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }),
        )
        .customerASN(customerASN?.applyValue({ args0 -> args0 }))
        .legacyMode(legacyMode?.applyValue({ args0 -> args0 }))
        .routingRegistryName(routingRegistryName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteCircuitPeeringConfigArgs].
 */
@PulumiTagMarker
public class ExpressRouteCircuitPeeringConfigArgsBuilder internal constructor() {
    private var advertisedCommunities: Output<List<String>>? = null

    private var advertisedPublicPrefixes: Output<List<String>>? = null

    private var customerASN: Output<Int>? = null

    private var legacyMode: Output<Int>? = null

    private var routingRegistryName: Output<String>? = null

    /**
     * @param value The communities of bgp peering. Specified for microsoft peering.
     */
    @JvmName("nxacbspgwejnelxg")
    public suspend fun advertisedCommunities(`value`: Output<List<String>>) {
        this.advertisedCommunities = value
    }

    @JvmName("ufksdmimqdxmjgqn")
    public suspend fun advertisedCommunities(vararg values: Output<String>) {
        this.advertisedCommunities = Output.all(values.asList())
    }

    /**
     * @param values The communities of bgp peering. Specified for microsoft peering.
     */
    @JvmName("ygblreypqaguungg")
    public suspend fun advertisedCommunities(values: List<Output<String>>) {
        this.advertisedCommunities = Output.all(values)
    }

    /**
     * @param value The reference to AdvertisedPublicPrefixes.
     */
    @JvmName("xqwvwhluhirupbku")
    public suspend fun advertisedPublicPrefixes(`value`: Output<List<String>>) {
        this.advertisedPublicPrefixes = value
    }

    @JvmName("ixtalliqknwwlfom")
    public suspend fun advertisedPublicPrefixes(vararg values: Output<String>) {
        this.advertisedPublicPrefixes = Output.all(values.asList())
    }

    /**
     * @param values The reference to AdvertisedPublicPrefixes.
     */
    @JvmName("jmfnnfdfqcvtybka")
    public suspend fun advertisedPublicPrefixes(values: List<Output<String>>) {
        this.advertisedPublicPrefixes = Output.all(values)
    }

    /**
     * @param value The CustomerASN of the peering.
     */
    @JvmName("arkvjfdlwolqpobr")
    public suspend fun customerASN(`value`: Output<Int>) {
        this.customerASN = value
    }

    /**
     * @param value The legacy mode of the peering.
     */
    @JvmName("hhulmlrfrkfhjlkp")
    public suspend fun legacyMode(`value`: Output<Int>) {
        this.legacyMode = value
    }

    /**
     * @param value The RoutingRegistryName of the configuration.
     */
    @JvmName("kswruthvcujjuxpk")
    public suspend fun routingRegistryName(`value`: Output<String>) {
        this.routingRegistryName = value
    }

    /**
     * @param value The communities of bgp peering. Specified for microsoft peering.
     */
    @JvmName("fvxisuydmpyatufv")
    public suspend fun advertisedCommunities(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advertisedCommunities = mapped
    }

    /**
     * @param values The communities of bgp peering. Specified for microsoft peering.
     */
    @JvmName("itirghxrgqggcaxa")
    public suspend fun advertisedCommunities(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advertisedCommunities = mapped
    }

    /**
     * @param value The reference to AdvertisedPublicPrefixes.
     */
    @JvmName("wxuaoqmebjnyjkok")
    public suspend fun advertisedPublicPrefixes(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.advertisedPublicPrefixes = mapped
    }

    /**
     * @param values The reference to AdvertisedPublicPrefixes.
     */
    @JvmName("eyvsuhrrgugrutbi")
    public suspend fun advertisedPublicPrefixes(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.advertisedPublicPrefixes = mapped
    }

    /**
     * @param value The CustomerASN of the peering.
     */
    @JvmName("xksjlkpjytrsqybm")
    public suspend fun customerASN(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerASN = mapped
    }

    /**
     * @param value The legacy mode of the peering.
     */
    @JvmName("pheuaihpjycyfpup")
    public suspend fun legacyMode(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.legacyMode = mapped
    }

    /**
     * @param value The RoutingRegistryName of the configuration.
     */
    @JvmName("spbbuceqtjtkpiie")
    public suspend fun routingRegistryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingRegistryName = mapped
    }

    internal fun build(): ExpressRouteCircuitPeeringConfigArgs = ExpressRouteCircuitPeeringConfigArgs(
        advertisedCommunities = advertisedCommunities,
        advertisedPublicPrefixes = advertisedPublicPrefixes,
        customerASN = customerASN,
        legacyMode = legacyMode,
        routingRegistryName = routingRegistryName,
    )
}
