@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * ExpressRouteConnection resource.
 * @property authorizationKey Authorization key to establish the connection.
 * @property enableInternetSecurity Enable internet security.
 * @property enablePrivateLinkFastPath Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
 * @property expressRouteCircuitPeering The ExpressRoute circuit peering.
 * @property expressRouteGatewayBypass Enable FastPath to vWan Firewall hub.
 * @property id Resource ID.
 * @property name The name of the resource.
 * @property routingConfiguration The Routing Configuration indicating the associated and propagated route tables on this connection.
 * @property routingWeight The routing weight associated to the connection.
 */
public data class ExpressRouteConnectionArgs(
    public val authorizationKey: Output<String>? = null,
    public val enableInternetSecurity: Output<Boolean>? = null,
    public val enablePrivateLinkFastPath: Output<Boolean>? = null,
    public val expressRouteCircuitPeering: Output<ExpressRouteCircuitPeeringIdArgs>,
    public val expressRouteGatewayBypass: Output<Boolean>? = null,
    public val id: Output<String>? = null,
    public val name: Output<String>,
    public val routingConfiguration: Output<RoutingConfigurationArgs>? = null,
    public val routingWeight: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteConnectionArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteConnectionArgs.builder()
            .authorizationKey(authorizationKey?.applyValue({ args0 -> args0 }))
            .enableInternetSecurity(enableInternetSecurity?.applyValue({ args0 -> args0 }))
            .enablePrivateLinkFastPath(enablePrivateLinkFastPath?.applyValue({ args0 -> args0 }))
            .expressRouteCircuitPeering(
                expressRouteCircuitPeering.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .expressRouteGatewayBypass(expressRouteGatewayBypass?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .routingConfiguration(
                routingConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .routingWeight(routingWeight?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExpressRouteConnectionArgs].
 */
@PulumiTagMarker
public class ExpressRouteConnectionArgsBuilder internal constructor() {
    private var authorizationKey: Output<String>? = null

    private var enableInternetSecurity: Output<Boolean>? = null

    private var enablePrivateLinkFastPath: Output<Boolean>? = null

    private var expressRouteCircuitPeering: Output<ExpressRouteCircuitPeeringIdArgs>? = null

    private var expressRouteGatewayBypass: Output<Boolean>? = null

    private var id: Output<String>? = null

    private var name: Output<String>? = null

    private var routingConfiguration: Output<RoutingConfigurationArgs>? = null

    private var routingWeight: Output<Int>? = null

    /**
     * @param value Authorization key to establish the connection.
     */
    @JvmName("judhofnbfpjfjrlk")
    public suspend fun authorizationKey(`value`: Output<String>) {
        this.authorizationKey = value
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("aryfpmdbpulmqyui")
    public suspend fun enableInternetSecurity(`value`: Output<Boolean>) {
        this.enableInternetSecurity = value
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("cyrvgshjgjyrpnmg")
    public suspend fun enablePrivateLinkFastPath(`value`: Output<Boolean>) {
        this.enablePrivateLinkFastPath = value
    }

    /**
     * @param value The ExpressRoute circuit peering.
     */
    @JvmName("vymmpvhrjuohfnmy")
    public suspend fun expressRouteCircuitPeering(`value`: Output<ExpressRouteCircuitPeeringIdArgs>) {
        this.expressRouteCircuitPeering = value
    }

    /**
     * @param value Enable FastPath to vWan Firewall hub.
     */
    @JvmName("uspjdpcggwtitxat")
    public suspend fun expressRouteGatewayBypass(`value`: Output<Boolean>) {
        this.expressRouteGatewayBypass = value
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("cbwliecrkycmawoq")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("dicpctpueunytigu")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("vingqtvsnqvbkgfh")
    public suspend fun routingConfiguration(`value`: Output<RoutingConfigurationArgs>) {
        this.routingConfiguration = value
    }

    /**
     * @param value The routing weight associated to the connection.
     */
    @JvmName("wvlpejhpepkmomvr")
    public suspend fun routingWeight(`value`: Output<Int>) {
        this.routingWeight = value
    }

    /**
     * @param value Authorization key to establish the connection.
     */
    @JvmName("ifystefupcbgnlii")
    public suspend fun authorizationKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authorizationKey = mapped
    }

    /**
     * @param value Enable internet security.
     */
    @JvmName("vrvjrlturpfqgnkn")
    public suspend fun enableInternetSecurity(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableInternetSecurity = mapped
    }

    /**
     * @param value Bypass the ExpressRoute gateway when accessing private-links. ExpressRoute FastPath (expressRouteGatewayBypass) must be enabled.
     */
    @JvmName("rwxgmfjqxpjkarmt")
    public suspend fun enablePrivateLinkFastPath(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePrivateLinkFastPath = mapped
    }

    /**
     * @param value The ExpressRoute circuit peering.
     */
    @JvmName("byubtbphlwxijfyi")
    public suspend fun expressRouteCircuitPeering(`value`: ExpressRouteCircuitPeeringIdArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param argument The ExpressRoute circuit peering.
     */
    @JvmName("nmkdeobntomnypye")
    public suspend fun expressRouteCircuitPeering(argument: suspend ExpressRouteCircuitPeeringIdArgsBuilder.() -> Unit) {
        val toBeMapped = ExpressRouteCircuitPeeringIdArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.expressRouteCircuitPeering = mapped
    }

    /**
     * @param value Enable FastPath to vWan Firewall hub.
     */
    @JvmName("fqyouaajvjsbhset")
    public suspend fun expressRouteGatewayBypass(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressRouteGatewayBypass = mapped
    }

    /**
     * @param value Resource ID.
     */
    @JvmName("gusjwsklbabiqvux")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The name of the resource.
     */
    @JvmName("pbdoeahpfyavqriq")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("heciqfvmhgwcvyeu")
    public suspend fun routingConfiguration(`value`: RoutingConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingConfiguration = mapped
    }

    /**
     * @param argument The Routing Configuration indicating the associated and propagated route tables on this connection.
     */
    @JvmName("dlvjqbiasdvjubvf")
    public suspend fun routingConfiguration(argument: suspend RoutingConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = RoutingConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.routingConfiguration = mapped
    }

    /**
     * @param value The routing weight associated to the connection.
     */
    @JvmName("jafbfdixmfjtnglw")
    public suspend fun routingWeight(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.routingWeight = mapped
    }

    internal fun build(): ExpressRouteConnectionArgs = ExpressRouteConnectionArgs(
        authorizationKey = authorizationKey,
        enableInternetSecurity = enableInternetSecurity,
        enablePrivateLinkFastPath = enablePrivateLinkFastPath,
        expressRouteCircuitPeering = expressRouteCircuitPeering ?: throw
            PulumiNullFieldException("expressRouteCircuitPeering"),
        expressRouteGatewayBypass = expressRouteGatewayBypass,
        id = id,
        name = name ?: throw PulumiNullFieldException("name"),
        routingConfiguration = routingConfiguration,
        routingWeight = routingWeight,
    )
}
