@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.ExpressRouteLinkMacSecConfigArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ExpressRouteLinkMacSecCipher
import com.pulumi.azurenative.network.kotlin.enums.ExpressRouteLinkMacSecSciState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * ExpressRouteLink Mac Security Configuration.
 * @property cakSecretIdentifier Keyvault Secret Identifier URL containing Mac security CAK key.
 * @property cipher Mac security cipher.
 * @property cknSecretIdentifier Keyvault Secret Identifier URL containing Mac security CKN key.
 * @property sciState Sci mode enabled/disabled.
 */
public data class ExpressRouteLinkMacSecConfigArgs(
    public val cakSecretIdentifier: Output<String>? = null,
    public val cipher: Output<Either<String, ExpressRouteLinkMacSecCipher>>? = null,
    public val cknSecretIdentifier: Output<String>? = null,
    public val sciState: Output<Either<String, ExpressRouteLinkMacSecSciState>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.ExpressRouteLinkMacSecConfigArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.ExpressRouteLinkMacSecConfigArgs =
        com.pulumi.azurenative.network.inputs.ExpressRouteLinkMacSecConfigArgs.builder()
            .cakSecretIdentifier(cakSecretIdentifier?.applyValue({ args0 -> args0 }))
            .cipher(
                cipher?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .cknSecretIdentifier(cknSecretIdentifier?.applyValue({ args0 -> args0 }))
            .sciState(
                sciState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExpressRouteLinkMacSecConfigArgs].
 */
@PulumiTagMarker
public class ExpressRouteLinkMacSecConfigArgsBuilder internal constructor() {
    private var cakSecretIdentifier: Output<String>? = null

    private var cipher: Output<Either<String, ExpressRouteLinkMacSecCipher>>? = null

    private var cknSecretIdentifier: Output<String>? = null

    private var sciState: Output<Either<String, ExpressRouteLinkMacSecSciState>>? = null

    /**
     * @param value Keyvault Secret Identifier URL containing Mac security CAK key.
     */
    @JvmName("livokaohlmsbkvec")
    public suspend fun cakSecretIdentifier(`value`: Output<String>) {
        this.cakSecretIdentifier = value
    }

    /**
     * @param value Mac security cipher.
     */
    @JvmName("idrnuxblnpsmwagw")
    public suspend fun cipher(`value`: Output<Either<String, ExpressRouteLinkMacSecCipher>>) {
        this.cipher = value
    }

    /**
     * @param value Keyvault Secret Identifier URL containing Mac security CKN key.
     */
    @JvmName("pdjledfufribhpid")
    public suspend fun cknSecretIdentifier(`value`: Output<String>) {
        this.cknSecretIdentifier = value
    }

    /**
     * @param value Sci mode enabled/disabled.
     */
    @JvmName("wynsmpqbkoitvxoj")
    public suspend fun sciState(`value`: Output<Either<String, ExpressRouteLinkMacSecSciState>>) {
        this.sciState = value
    }

    /**
     * @param value Keyvault Secret Identifier URL containing Mac security CAK key.
     */
    @JvmName("rshjxnteurgylxen")
    public suspend fun cakSecretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cakSecretIdentifier = mapped
    }

    /**
     * @param value Mac security cipher.
     */
    @JvmName("xhrwyeuffpoqhjhh")
    public suspend fun cipher(`value`: Either<String, ExpressRouteLinkMacSecCipher>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cipher = mapped
    }

    /**
     * @param value Mac security cipher.
     */
    @JvmName("uobirnlkpaxskgqf")
    public fun cipher(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRouteLinkMacSecCipher>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cipher = mapped
    }

    /**
     * @param value Mac security cipher.
     */
    @JvmName("psbwjvelfervdaxm")
    public fun cipher(`value`: ExpressRouteLinkMacSecCipher) {
        val toBeMapped = Either.ofRight<String, ExpressRouteLinkMacSecCipher>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cipher = mapped
    }

    /**
     * @param value Keyvault Secret Identifier URL containing Mac security CKN key.
     */
    @JvmName("emsjimeytfbhenhr")
    public suspend fun cknSecretIdentifier(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cknSecretIdentifier = mapped
    }

    /**
     * @param value Sci mode enabled/disabled.
     */
    @JvmName("stcaiptnlhflpvda")
    public suspend fun sciState(`value`: Either<String, ExpressRouteLinkMacSecSciState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sciState = mapped
    }

    /**
     * @param value Sci mode enabled/disabled.
     */
    @JvmName("ffbmnmawqsxpjaqb")
    public fun sciState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ExpressRouteLinkMacSecSciState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sciState = mapped
    }

    /**
     * @param value Sci mode enabled/disabled.
     */
    @JvmName("klxrnftbghcctusq")
    public fun sciState(`value`: ExpressRouteLinkMacSecSciState) {
        val toBeMapped = Either.ofRight<String, ExpressRouteLinkMacSecSciState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sciState = mapped
    }

    internal fun build(): ExpressRouteLinkMacSecConfigArgs = ExpressRouteLinkMacSecConfigArgs(
        cakSecretIdentifier = cakSecretIdentifier,
        cipher = cipher,
        cknSecretIdentifier = cknSecretIdentifier,
        sciState = sciState,
    )
}
