@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Firewall Policy Filter Rule Collection.
 * @property action The action type of a Filter rule collection.
 * @property name The name of the rule collection.
 * @property priority Priority of the Firewall Policy Rule Collection resource.
 * @property ruleCollectionType The type of the rule collection.
 * Expected value is 'FirewallPolicyFilterRuleCollection'.
 * @property rules List of rules included in a rule collection.
 */
public data class FirewallPolicyFilterRuleCollectionArgs(
    public val action: Output<FirewallPolicyFilterRuleCollectionActionArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val ruleCollectionType: Output<String>,
    public val rules: Output<List<Any>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyFilterRuleCollectionArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .ruleCollectionType(ruleCollectionType.applyValue({ args0 -> args0 }))
            .rules(rules?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FirewallPolicyFilterRuleCollectionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyFilterRuleCollectionArgsBuilder internal constructor() {
    private var action: Output<FirewallPolicyFilterRuleCollectionActionArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleCollectionType: Output<String>? = null

    private var rules: Output<List<Any>>? = null

    /**
     * @param value The action type of a Filter rule collection.
     */
    @JvmName("asqasvcosqlblyoc")
    public suspend fun action(`value`: Output<FirewallPolicyFilterRuleCollectionActionArgs>) {
        this.action = value
    }

    /**
     * @param value The name of the rule collection.
     */
    @JvmName("grwbpbuooxhccnqy")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection resource.
     */
    @JvmName("vyrgpvrwxkryjmwp")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The type of the rule collection.
     * Expected value is 'FirewallPolicyFilterRuleCollection'.
     */
    @JvmName("lkmxtwculpqkoqhh")
    public suspend fun ruleCollectionType(`value`: Output<String>) {
        this.ruleCollectionType = value
    }

    /**
     * @param value List of rules included in a rule collection.
     */
    @JvmName("eidmggjsjnlscfnb")
    public suspend fun rules(`value`: Output<List<Any>>) {
        this.rules = value
    }

    @JvmName("utebarynhpjajsun")
    public suspend fun rules(vararg values: Output<Any>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules included in a rule collection.
     */
    @JvmName("geemqgswskbxsgpq")
    public suspend fun rules(values: List<Output<Any>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value The action type of a Filter rule collection.
     */
    @JvmName("ohuokqndmonnsmdi")
    public suspend fun action(`value`: FirewallPolicyFilterRuleCollectionActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a Filter rule collection.
     */
    @JvmName("nrooouxxtvhdiflm")
    public suspend fun action(argument: suspend FirewallPolicyFilterRuleCollectionActionArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyFilterRuleCollectionActionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The name of the rule collection.
     */
    @JvmName("wqsyuhuonsitywdo")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule Collection resource.
     */
    @JvmName("tiegjufaqoxipqjf")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The type of the rule collection.
     * Expected value is 'FirewallPolicyFilterRuleCollection'.
     */
    @JvmName("kcdlleandaheqwjq")
    public suspend fun ruleCollectionType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleCollectionType = mapped
    }

    /**
     * @param value List of rules included in a rule collection.
     */
    @JvmName("hgyfuaqucokgrfro")
    public suspend fun rules(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param values List of rules included in a rule collection.
     */
    @JvmName("xuosnyrfrnwwkrxe")
    public suspend fun rules(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): FirewallPolicyFilterRuleCollectionArgs =
        FirewallPolicyFilterRuleCollectionArgs(
            action = action,
            name = name,
            priority = priority,
            ruleCollectionType = ruleCollectionType ?: throw PulumiNullFieldException("ruleCollectionType"),
            rules = rules,
        )
}
