@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsResourcesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Log Analytics Resources for Firewall Policy Insights.
 * @property defaultWorkspaceId The default workspace Id for Firewall Policy Insights.
 * @property workspaces List of workspaces for Firewall Policy Insights.
 */
public data class FirewallPolicyLogAnalyticsResourcesArgs(
    public val defaultWorkspaceId: Output<SubResourceArgs>? = null,
    public val workspaces: Output<List<FirewallPolicyLogAnalyticsWorkspaceArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsResourcesArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsResourcesArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyLogAnalyticsResourcesArgs.builder()
            .defaultWorkspaceId(
                defaultWorkspaceId?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .workspaces(
                workspaces?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyLogAnalyticsResourcesArgs].
 */
@PulumiTagMarker
public class FirewallPolicyLogAnalyticsResourcesArgsBuilder internal constructor() {
    private var defaultWorkspaceId: Output<SubResourceArgs>? = null

    private var workspaces: Output<List<FirewallPolicyLogAnalyticsWorkspaceArgs>>? = null

    /**
     * @param value The default workspace Id for Firewall Policy Insights.
     */
    @JvmName("tjkjpfpmggxqjqtl")
    public suspend fun defaultWorkspaceId(`value`: Output<SubResourceArgs>) {
        this.defaultWorkspaceId = value
    }

    /**
     * @param value List of workspaces for Firewall Policy Insights.
     */
    @JvmName("rpyveerwunkubcop")
    public suspend fun workspaces(`value`: Output<List<FirewallPolicyLogAnalyticsWorkspaceArgs>>) {
        this.workspaces = value
    }

    @JvmName("oyebldmigwlqwepr")
    public suspend fun workspaces(vararg values: Output<FirewallPolicyLogAnalyticsWorkspaceArgs>) {
        this.workspaces = Output.all(values.asList())
    }

    /**
     * @param values List of workspaces for Firewall Policy Insights.
     */
    @JvmName("efjorvuyfqjoirry")
    public suspend fun workspaces(values: List<Output<FirewallPolicyLogAnalyticsWorkspaceArgs>>) {
        this.workspaces = Output.all(values)
    }

    /**
     * @param value The default workspace Id for Firewall Policy Insights.
     */
    @JvmName("yofwinubbupiydrk")
    public suspend fun defaultWorkspaceId(`value`: SubResourceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultWorkspaceId = mapped
    }

    /**
     * @param argument The default workspace Id for Firewall Policy Insights.
     */
    @JvmName("gsmgknqkfkdgqlrj")
    public suspend fun defaultWorkspaceId(argument: suspend SubResourceArgsBuilder.() -> Unit) {
        val toBeMapped = SubResourceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.defaultWorkspaceId = mapped
    }

    /**
     * @param value List of workspaces for Firewall Policy Insights.
     */
    @JvmName("krdwrrobvwakpwvh")
    public suspend fun workspaces(`value`: List<FirewallPolicyLogAnalyticsWorkspaceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaces = mapped
    }

    /**
     * @param argument List of workspaces for Firewall Policy Insights.
     */
    @JvmName("ffiimidtxsuatiqe")
    public suspend fun workspaces(argument: List<suspend FirewallPolicyLogAnalyticsWorkspaceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyLogAnalyticsWorkspaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workspaces = mapped
    }

    /**
     * @param argument List of workspaces for Firewall Policy Insights.
     */
    @JvmName("aadqvfkiokjngshp")
    public suspend fun workspaces(vararg argument: suspend FirewallPolicyLogAnalyticsWorkspaceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FirewallPolicyLogAnalyticsWorkspaceArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.workspaces = mapped
    }

    /**
     * @param argument List of workspaces for Firewall Policy Insights.
     */
    @JvmName("bryqqtwijvsdpulm")
    public suspend fun workspaces(argument: suspend FirewallPolicyLogAnalyticsWorkspaceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FirewallPolicyLogAnalyticsWorkspaceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.workspaces = mapped
    }

    /**
     * @param values List of workspaces for Firewall Policy Insights.
     */
    @JvmName("saejtpyjwqdyiash")
    public suspend fun workspaces(vararg values: FirewallPolicyLogAnalyticsWorkspaceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.workspaces = mapped
    }

    internal fun build(): FirewallPolicyLogAnalyticsResourcesArgs =
        FirewallPolicyLogAnalyticsResourcesArgs(
            defaultWorkspaceId = defaultWorkspaceId,
            workspaces = workspaces,
        )
}
