@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleActionArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicyNatRuleActionType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Properties of the FirewallPolicyNatRuleAction.
 * @property type The type of action.
 */
public data class FirewallPolicyNatRuleActionArgs(
    public val type: Output<Either<String, FirewallPolicyNatRuleActionType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleActionArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleActionArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleActionArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicyNatRuleActionArgs].
 */
@PulumiTagMarker
public class FirewallPolicyNatRuleActionArgsBuilder internal constructor() {
    private var type: Output<Either<String, FirewallPolicyNatRuleActionType>>? = null

    /**
     * @param value The type of action.
     */
    @JvmName("eyybsfswfqbxpdhx")
    public suspend fun type(`value`: Output<Either<String, FirewallPolicyNatRuleActionType>>) {
        this.type = value
    }

    /**
     * @param value The type of action.
     */
    @JvmName("tqfwqdfycctvkacd")
    public suspend fun type(`value`: Either<String, FirewallPolicyNatRuleActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("oiwhfacfycsmjcpl")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicyNatRuleActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The type of action.
     */
    @JvmName("ycvdvguhptyoqxep")
    public fun type(`value`: FirewallPolicyNatRuleActionType) {
        val toBeMapped = Either.ofRight<String, FirewallPolicyNatRuleActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FirewallPolicyNatRuleActionArgs = FirewallPolicyNatRuleActionArgs(
        type = type,
    )
}
