@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Firewall Policy NAT Rule.
 * @property action The action type of a Nat rule.
 * @property name The name of the rule.
 * @property priority Priority of the Firewall Policy Rule resource.
 * @property ruleCondition The match conditions for incoming traffic.
 * @property ruleType The type of the rule.
 * Expected value is 'FirewallPolicyNatRule'.
 * @property translatedAddress The translated address for this NAT rule.
 * @property translatedPort The translated port for this NAT rule.
 */
public data class FirewallPolicyNatRuleArgs(
    public val action: Output<FirewallPolicyNatRuleActionArgs>? = null,
    public val name: Output<String>? = null,
    public val priority: Output<Int>? = null,
    public val ruleCondition: Output<Any>? = null,
    public val ruleType: Output<String>,
    public val translatedAddress: Output<String>? = null,
    public val translatedPort: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicyNatRuleArgs.builder()
            .action(action?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .priority(priority?.applyValue({ args0 -> args0 }))
            .ruleCondition(ruleCondition?.applyValue({ args0 -> args0 }))
            .ruleType(ruleType.applyValue({ args0 -> args0 }))
            .translatedAddress(translatedAddress?.applyValue({ args0 -> args0 }))
            .translatedPort(translatedPort?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FirewallPolicyNatRuleArgs].
 */
@PulumiTagMarker
public class FirewallPolicyNatRuleArgsBuilder internal constructor() {
    private var action: Output<FirewallPolicyNatRuleActionArgs>? = null

    private var name: Output<String>? = null

    private var priority: Output<Int>? = null

    private var ruleCondition: Output<Any>? = null

    private var ruleType: Output<String>? = null

    private var translatedAddress: Output<String>? = null

    private var translatedPort: Output<String>? = null

    /**
     * @param value The action type of a Nat rule.
     */
    @JvmName("qrdtwbtsucpyrvxu")
    public suspend fun action(`value`: Output<FirewallPolicyNatRuleActionArgs>) {
        this.action = value
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("bxdqbwlotxgxkubt")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Priority of the Firewall Policy Rule resource.
     */
    @JvmName("hyfhxdbcrebobugy")
    public suspend fun priority(`value`: Output<Int>) {
        this.priority = value
    }

    /**
     * @param value The match conditions for incoming traffic.
     */
    @JvmName("fqhftjfnnbrjlteo")
    public suspend fun ruleCondition(`value`: Output<Any>) {
        this.ruleCondition = value
    }

    /**
     * @param value The type of the rule.
     * Expected value is 'FirewallPolicyNatRule'.
     */
    @JvmName("qwdfribmiudeecbe")
    public suspend fun ruleType(`value`: Output<String>) {
        this.ruleType = value
    }

    /**
     * @param value The translated address for this NAT rule.
     */
    @JvmName("qvbksosiqytnrgiq")
    public suspend fun translatedAddress(`value`: Output<String>) {
        this.translatedAddress = value
    }

    /**
     * @param value The translated port for this NAT rule.
     */
    @JvmName("kemehnrrdwuieffg")
    public suspend fun translatedPort(`value`: Output<String>) {
        this.translatedPort = value
    }

    /**
     * @param value The action type of a Nat rule.
     */
    @JvmName("qxkqgnpkxelymudx")
    public suspend fun action(`value`: FirewallPolicyNatRuleActionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param argument The action type of a Nat rule.
     */
    @JvmName("mpajjnanpajtohhv")
    public suspend fun action(argument: suspend FirewallPolicyNatRuleActionArgsBuilder.() -> Unit) {
        val toBeMapped = FirewallPolicyNatRuleActionArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.action = mapped
    }

    /**
     * @param value The name of the rule.
     */
    @JvmName("dshmaagaaqnobgvk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Priority of the Firewall Policy Rule resource.
     */
    @JvmName("jxfkjxhsshrahpgc")
    public suspend fun priority(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.priority = mapped
    }

    /**
     * @param value The match conditions for incoming traffic.
     */
    @JvmName("kjvxyirlgvndcltp")
    public suspend fun ruleCondition(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ruleCondition = mapped
    }

    /**
     * @param value The type of the rule.
     * Expected value is 'FirewallPolicyNatRule'.
     */
    @JvmName("bjpirqlputbtpruy")
    public suspend fun ruleType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleType = mapped
    }

    /**
     * @param value The translated address for this NAT rule.
     */
    @JvmName("yissjdadvrlrywdr")
    public suspend fun translatedAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedAddress = mapped
    }

    /**
     * @param value The translated port for this NAT rule.
     */
    @JvmName("maoxqdiltfsjvnbv")
    public suspend fun translatedPort(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.translatedPort = mapped
    }

    internal fun build(): FirewallPolicyNatRuleArgs = FirewallPolicyNatRuleArgs(
        action = action,
        name = name,
        priority = priority,
        ruleCondition = ruleCondition,
        ruleType = ruleType ?: throw PulumiNullFieldException("ruleType"),
        translatedAddress = translatedAddress,
        translatedPort = translatedPort,
    )
}
