@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FirewallPolicySkuArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FirewallPolicySkuTier
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * SKU of Firewall policy.
 * @property tier Tier of Firewall Policy.
 */
public data class FirewallPolicySkuArgs(
    public val tier: Output<Either<String, FirewallPolicySkuTier>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FirewallPolicySkuArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FirewallPolicySkuArgs =
        com.pulumi.azurenative.network.inputs.FirewallPolicySkuArgs.builder()
            .tier(
                tier?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [FirewallPolicySkuArgs].
 */
@PulumiTagMarker
public class FirewallPolicySkuArgsBuilder internal constructor() {
    private var tier: Output<Either<String, FirewallPolicySkuTier>>? = null

    /**
     * @param value Tier of Firewall Policy.
     */
    @JvmName("bxlbbssepugghaiu")
    public suspend fun tier(`value`: Output<Either<String, FirewallPolicySkuTier>>) {
        this.tier = value
    }

    /**
     * @param value Tier of Firewall Policy.
     */
    @JvmName("wjnqtjklbxipsqfw")
    public suspend fun tier(`value`: Either<String, FirewallPolicySkuTier>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of Firewall Policy.
     */
    @JvmName("lxwaefhutcvifhss")
    public fun tier(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FirewallPolicySkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    /**
     * @param value Tier of Firewall Policy.
     */
    @JvmName("buckmnpggktbprjw")
    public fun tier(`value`: FirewallPolicySkuTier) {
        val toBeMapped = Either.ofRight<String, FirewallPolicySkuTier>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tier = mapped
    }

    internal fun build(): FirewallPolicySkuArgs = FirewallPolicySkuArgs(
        tier = tier,
    )
}
