@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FlowLogFormatParametersArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.FlowLogFormatType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Parameters that define the flow log format.
 * @property type The file type of flow log.
 * @property version The version (revision) of the flow log.
 */
public data class FlowLogFormatParametersArgs(
    public val type: Output<Either<String, FlowLogFormatType>>? = null,
    public val version: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FlowLogFormatParametersArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FlowLogFormatParametersArgs =
        com.pulumi.azurenative.network.inputs.FlowLogFormatParametersArgs.builder()
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .version(version?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FlowLogFormatParametersArgs].
 */
@PulumiTagMarker
public class FlowLogFormatParametersArgsBuilder internal constructor() {
    private var type: Output<Either<String, FlowLogFormatType>>? = null

    private var version: Output<Int>? = null

    /**
     * @param value The file type of flow log.
     */
    @JvmName("krxgjnffsrysncwo")
    public suspend fun type(`value`: Output<Either<String, FlowLogFormatType>>) {
        this.type = value
    }

    /**
     * @param value The version (revision) of the flow log.
     */
    @JvmName("yufgkwecgdnljyqi")
    public suspend fun version(`value`: Output<Int>) {
        this.version = value
    }

    /**
     * @param value The file type of flow log.
     */
    @JvmName("fttlixvqvcutspai")
    public suspend fun type(`value`: Either<String, FlowLogFormatType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The file type of flow log.
     */
    @JvmName("pkoiqtbvflrobitm")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FlowLogFormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The file type of flow log.
     */
    @JvmName("kuradwoyfmaojnsj")
    public fun type(`value`: FlowLogFormatType) {
        val toBeMapped = Either.ofRight<String, FlowLogFormatType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The version (revision) of the flow log.
     */
    @JvmName("lldnwlcfrhtocqur")
    public suspend fun version(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.version = mapped
    }

    internal fun build(): FlowLogFormatParametersArgs = FlowLogFormatParametersArgs(
        type = type,
        version = version,
    )
}
