@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleGroupOverrideArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule group override setting.
 * @property exclusions Describes the exclusions that are applied to all rules in the group.
 * @property ruleGroupName Describes the managed rule group to override.
 * @property rules List of rules that will be disabled. If none specified, all rules in the group will be disabled.
 */
public data class FrontDoorManagedRuleGroupOverrideArgs(
    public val exclusions: Output<List<ManagedRuleExclusionArgs>>? = null,
    public val ruleGroupName: Output<String>,
    public val rules: Output<List<FrontDoorManagedRuleOverrideArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleGroupOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleGroupOverrideArgs = com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleGroupOverrideArgs.builder()
        .exclusions(
            exclusions?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        )
        .ruleGroupName(ruleGroupName.applyValue({ args0 -> args0 }))
        .rules(
            rules?.applyValue({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                })
            }),
        ).build()
}

/**
 * Builder for [FrontDoorManagedRuleGroupOverrideArgs].
 */
@PulumiTagMarker
public class FrontDoorManagedRuleGroupOverrideArgsBuilder internal constructor() {
    private var exclusions: Output<List<ManagedRuleExclusionArgs>>? = null

    private var ruleGroupName: Output<String>? = null

    private var rules: Output<List<FrontDoorManagedRuleOverrideArgs>>? = null

    /**
     * @param value Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("kamahtkjipgrhvuh")
    public suspend fun exclusions(`value`: Output<List<ManagedRuleExclusionArgs>>) {
        this.exclusions = value
    }

    @JvmName("bglotyedgfawqarl")
    public suspend fun exclusions(vararg values: Output<ManagedRuleExclusionArgs>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("mxvdytjnfsiuytmh")
    public suspend fun exclusions(values: List<Output<ManagedRuleExclusionArgs>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value Describes the managed rule group to override.
     */
    @JvmName("vvachplvbxfpchwk")
    public suspend fun ruleGroupName(`value`: Output<String>) {
        this.ruleGroupName = value
    }

    /**
     * @param value List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("pssuqrdwxtdnsqub")
    public suspend fun rules(`value`: Output<List<FrontDoorManagedRuleOverrideArgs>>) {
        this.rules = value
    }

    @JvmName("sjcjihvbwxmwpytf")
    public suspend fun rules(vararg values: Output<FrontDoorManagedRuleOverrideArgs>) {
        this.rules = Output.all(values.asList())
    }

    /**
     * @param values List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("qtxuhekjngoahnsy")
    public suspend fun rules(values: List<Output<FrontDoorManagedRuleOverrideArgs>>) {
        this.rules = Output.all(values)
    }

    /**
     * @param value Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("bwpxiwuxtnrbptcg")
    public suspend fun exclusions(`value`: List<ManagedRuleExclusionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("dayvvtypmqwmsdsv")
    public suspend fun exclusions(argument: List<suspend ManagedRuleExclusionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("rxciufpurhycjtdj")
    public suspend fun exclusions(vararg argument: suspend ManagedRuleExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedRuleExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("sngrcddvneoaoiiw")
    public suspend fun exclusions(argument: suspend ManagedRuleExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedRuleExclusionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param values Describes the exclusions that are applied to all rules in the group.
     */
    @JvmName("stxaacaumjxkqbsj")
    public suspend fun exclusions(vararg values: ManagedRuleExclusionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value Describes the managed rule group to override.
     */
    @JvmName("cruwbxnnyksxkbog")
    public suspend fun ruleGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleGroupName = mapped
    }

    /**
     * @param value List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("oisjgmqftkpcohik")
    public suspend fun rules(`value`: List<FrontDoorManagedRuleOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("jrangbwyyhqrbham")
    public suspend fun rules(argument: List<suspend FrontDoorManagedRuleOverrideArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            FrontDoorManagedRuleOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("ebdnaymnishoapiq")
    public suspend fun rules(vararg argument: suspend FrontDoorManagedRuleOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            FrontDoorManagedRuleOverrideArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param argument List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("caqamtacbtieprgw")
    public suspend fun rules(argument: suspend FrontDoorManagedRuleOverrideArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            FrontDoorManagedRuleOverrideArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.rules = mapped
    }

    /**
     * @param values List of rules that will be disabled. If none specified, all rules in the group will be disabled.
     */
    @JvmName("lcditgvgpyqrhrec")
    public suspend fun rules(vararg values: FrontDoorManagedRuleOverrideArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rules = mapped
    }

    internal fun build(): FrontDoorManagedRuleGroupOverrideArgs =
        FrontDoorManagedRuleGroupOverrideArgs(
            exclusions = exclusions,
            ruleGroupName = ruleGroupName ?: throw PulumiNullFieldException("ruleGroupName"),
            rules = rules,
        )
}
