@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleOverrideArgs.builder
import com.pulumi.azurenative.network.kotlin.enums.ActionType
import com.pulumi.azurenative.network.kotlin.enums.ManagedRuleEnabledState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Defines a managed rule group override setting.
 * @property action Describes the override action to be applied when rule matches.
 * @property enabledState Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
 * @property exclusions Describes the exclusions that are applied to this specific rule.
 * @property ruleId Identifier for the managed rule.
 */
public data class FrontDoorManagedRuleOverrideArgs(
    public val action: Output<Either<String, ActionType>>? = null,
    public val enabledState: Output<Either<String, ManagedRuleEnabledState>>? = null,
    public val exclusions: Output<List<ManagedRuleExclusionArgs>>? = null,
    public val ruleId: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleOverrideArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleOverrideArgs =
        com.pulumi.azurenative.network.inputs.FrontDoorManagedRuleOverrideArgs.builder()
            .action(
                action?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .enabledState(
                enabledState?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .exclusions(
                exclusions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .ruleId(ruleId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FrontDoorManagedRuleOverrideArgs].
 */
@PulumiTagMarker
public class FrontDoorManagedRuleOverrideArgsBuilder internal constructor() {
    private var action: Output<Either<String, ActionType>>? = null

    private var enabledState: Output<Either<String, ManagedRuleEnabledState>>? = null

    private var exclusions: Output<List<ManagedRuleExclusionArgs>>? = null

    private var ruleId: Output<String>? = null

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("byuabiqororvhxcp")
    public suspend fun action(`value`: Output<Either<String, ActionType>>) {
        this.action = value
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("ujwlsprupkoxkqym")
    public suspend fun enabledState(`value`: Output<Either<String, ManagedRuleEnabledState>>) {
        this.enabledState = value
    }

    /**
     * @param value Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("lixaycgqisfrkitu")
    public suspend fun exclusions(`value`: Output<List<ManagedRuleExclusionArgs>>) {
        this.exclusions = value
    }

    @JvmName("upmvuekjowekrwrf")
    public suspend fun exclusions(vararg values: Output<ManagedRuleExclusionArgs>) {
        this.exclusions = Output.all(values.asList())
    }

    /**
     * @param values Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("nejhbffqnefkepua")
    public suspend fun exclusions(values: List<Output<ManagedRuleExclusionArgs>>) {
        this.exclusions = Output.all(values)
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("efstcivoqscmipci")
    public suspend fun ruleId(`value`: Output<String>) {
        this.ruleId = value
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("rocrvonvvupknkfs")
    public suspend fun action(`value`: Either<String, ActionType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("ecqhmjorwephwjlk")
    public fun action(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes the override action to be applied when rule matches.
     */
    @JvmName("qeccberbkkaajjfq")
    public fun action(`value`: ActionType) {
        val toBeMapped = Either.ofRight<String, ActionType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("ckcqlwxfnqpdypui")
    public suspend fun enabledState(`value`: Either<String, ManagedRuleEnabledState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("meheaeqxinlhpwsr")
    public fun enabledState(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ManagedRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes if the managed rule is in enabled or disabled state. Defaults to Disabled if not specified.
     */
    @JvmName("bphghgmpwqhwdkpn")
    public fun enabledState(`value`: ManagedRuleEnabledState) {
        val toBeMapped = Either.ofRight<String, ManagedRuleEnabledState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabledState = mapped
    }

    /**
     * @param value Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("ulfecybpgouutado")
    public suspend fun exclusions(`value`: List<ManagedRuleExclusionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("urgjgemsxkfwtjbm")
    public suspend fun exclusions(argument: List<suspend ManagedRuleExclusionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ManagedRuleExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("ensncsfxalyfjsyj")
    public suspend fun exclusions(vararg argument: suspend ManagedRuleExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ManagedRuleExclusionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param argument Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("ratwdbadqsriffna")
    public suspend fun exclusions(argument: suspend ManagedRuleExclusionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ManagedRuleExclusionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.exclusions = mapped
    }

    /**
     * @param values Describes the exclusions that are applied to this specific rule.
     */
    @JvmName("cqlxrwtoqpwodoqx")
    public suspend fun exclusions(vararg values: ManagedRuleExclusionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.exclusions = mapped
    }

    /**
     * @param value Identifier for the managed rule.
     */
    @JvmName("pnritsgumegrlios")
    public suspend fun ruleId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleId = mapped
    }

    internal fun build(): FrontDoorManagedRuleOverrideArgs = FrontDoorManagedRuleOverrideArgs(
        action = action,
        enabledState = enabledState,
        exclusions = exclusions,
        ruleId = ruleId ?: throw PulumiNullFieldException("ruleId"),
    )
}
