@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetApplicationGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property applicationGatewayName The name of the application gateway.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetApplicationGatewayPlainArgs(
    public val applicationGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetApplicationGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetApplicationGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetApplicationGatewayPlainArgs.builder()
            .applicationGatewayName(applicationGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetApplicationGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetApplicationGatewayPlainArgsBuilder internal constructor() {
    private var applicationGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the application gateway.
     */
    @JvmName("stasuifqkxcbsuai")
    public suspend fun applicationGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.applicationGatewayName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("sfkpulthdxcidayi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetApplicationGatewayPlainArgs = GetApplicationGatewayPlainArgs(
        applicationGatewayName = applicationGatewayName ?: throw
            PulumiNullFieldException("applicationGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
