@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetBastionShareableLinkPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property bastionHostName The name of the Bastion Host.
 * @property resourceGroupName The name of the resource group.
 * @property vms List of VM references.
 */
public data class GetBastionShareableLinkPlainArgs(
    public val bastionHostName: String,
    public val resourceGroupName: String,
    public val vms: List<BastionShareableLink>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetBastionShareableLinkPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetBastionShareableLinkPlainArgs =
        com.pulumi.azurenative.network.inputs.GetBastionShareableLinkPlainArgs.builder()
            .bastionHostName(bastionHostName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vms(vms?.let({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) })).build()
}

/**
 * Builder for [GetBastionShareableLinkPlainArgs].
 */
@PulumiTagMarker
public class GetBastionShareableLinkPlainArgsBuilder internal constructor() {
    private var bastionHostName: String? = null

    private var resourceGroupName: String? = null

    private var vms: List<BastionShareableLink>? = null

    /**
     * @param value The name of the Bastion Host.
     */
    @JvmName("yjraeqevtnutdiuv")
    public suspend fun bastionHostName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.bastionHostName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ssgccgasxrgnmbtv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value List of VM references.
     */
    @JvmName("cuuuuoouexxdhoop")
    public suspend fun vms(`value`: List<BastionShareableLink>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.vms = mapped
    }

    /**
     * @param argument List of VM references.
     */
    @JvmName("woffsreqigblcfto")
    public suspend fun vms(argument: List<suspend BastionShareableLinkBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            BastionShareableLinkBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.vms = mapped
    }

    /**
     * @param argument List of VM references.
     */
    @JvmName("tqtsdbjhkmnoxekt")
    public suspend fun vms(vararg argument: suspend BastionShareableLinkBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            BastionShareableLinkBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = toBeMapped
        this.vms = mapped
    }

    /**
     * @param argument List of VM references.
     */
    @JvmName("qeketoviitheewxy")
    public suspend fun vms(argument: suspend BastionShareableLinkBuilder.() -> Unit) {
        val toBeMapped = listOf(BastionShareableLinkBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.vms = mapped
    }

    /**
     * @param values List of VM references.
     */
    @JvmName("shinhlftclcjtvts")
    public suspend fun vms(vararg values: BastionShareableLink) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vms = mapped
    }

    internal fun build(): GetBastionShareableLinkPlainArgs = GetBastionShareableLinkPlainArgs(
        bastionHostName = bastionHostName ?: throw PulumiNullFieldException("bastionHostName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        vms = vms,
    )
}
