@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDnsForwardingRulesetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsForwardingRulesetName The name of the DNS forwarding ruleset.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDnsForwardingRulesetPlainArgs(
    public val dnsForwardingRulesetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDnsForwardingRulesetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDnsForwardingRulesetPlainArgs =
        com.pulumi.azurenative.network.inputs.GetDnsForwardingRulesetPlainArgs.builder()
            .dnsForwardingRulesetName(dnsForwardingRulesetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDnsForwardingRulesetPlainArgs].
 */
@PulumiTagMarker
public class GetDnsForwardingRulesetPlainArgsBuilder internal constructor() {
    private var dnsForwardingRulesetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DNS forwarding ruleset.
     */
    @JvmName("datwtashsdthfgeo")
    public suspend fun dnsForwardingRulesetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsForwardingRulesetName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("owjmwnycsxhfrhev")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDnsForwardingRulesetPlainArgs = GetDnsForwardingRulesetPlainArgs(
        dnsForwardingRulesetName = dnsForwardingRulesetName ?: throw
            PulumiNullFieldException("dnsForwardingRulesetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
