@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDnsResolverPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property dnsResolverName The name of the DNS resolver.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class GetDnsResolverPlainArgs(
    public val dnsResolverName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDnsResolverPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDnsResolverPlainArgs =
        com.pulumi.azurenative.network.inputs.GetDnsResolverPlainArgs.builder()
            .dnsResolverName(dnsResolverName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDnsResolverPlainArgs].
 */
@PulumiTagMarker
public class GetDnsResolverPlainArgsBuilder internal constructor() {
    private var dnsResolverName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the DNS resolver.
     */
    @JvmName("ddykrelitakjiqeg")
    public suspend fun dnsResolverName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.dnsResolverName = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("aohrjtdckmdlhsru")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetDnsResolverPlainArgs = GetDnsResolverPlainArgs(
        dnsResolverName = dnsResolverName ?: throw PulumiNullFieldException("dnsResolverName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
