@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetDnsResourceReferenceByTarResourcesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property targetResources A list of references to azure resources for which referencing dns records need to be queried.
 */
public data class GetDnsResourceReferenceByTarResourcesPlainArgs(
    public val targetResources: List<SubResource>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetDnsResourceReferenceByTarResourcesPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetDnsResourceReferenceByTarResourcesPlainArgs =
        com.pulumi.azurenative.network.inputs.GetDnsResourceReferenceByTarResourcesPlainArgs.builder()
            .targetResources(
                targetResources?.let({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [GetDnsResourceReferenceByTarResourcesPlainArgs].
 */
@PulumiTagMarker
public class GetDnsResourceReferenceByTarResourcesPlainArgsBuilder internal constructor() {
    private var targetResources: List<SubResource>? = null

    /**
     * @param value A list of references to azure resources for which referencing dns records need to be queried.
     */
    @JvmName("vbjjtsextunayxan")
    public suspend fun targetResources(`value`: List<SubResource>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.targetResources = mapped
    }

    /**
     * @param argument A list of references to azure resources for which referencing dns records need to be queried.
     */
    @JvmName("umhabsnquhxnwgyr")
    public suspend fun targetResources(argument: List<suspend SubResourceBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { SubResourceBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.targetResources = mapped
    }

    /**
     * @param argument A list of references to azure resources for which referencing dns records need to be queried.
     */
    @JvmName("unowfmflxaesphpf")
    public suspend fun targetResources(vararg argument: suspend SubResourceBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { SubResourceBuilder().applySuspend { it() }.build() }
        val mapped = toBeMapped
        this.targetResources = mapped
    }

    /**
     * @param argument A list of references to azure resources for which referencing dns records need to be queried.
     */
    @JvmName("smfgjvswtjppqywj")
    public suspend fun targetResources(argument: suspend SubResourceBuilder.() -> Unit) {
        val toBeMapped = listOf(SubResourceBuilder().applySuspend { argument() }.build())
        val mapped = toBeMapped
        this.targetResources = mapped
    }

    /**
     * @param values A list of references to azure resources for which referencing dns records need to be queried.
     */
    @JvmName("paiobjhilcgmdegn")
    public suspend fun targetResources(vararg values: SubResource) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.targetResources = mapped
    }

    internal fun build(): GetDnsResourceReferenceByTarResourcesPlainArgs =
        GetDnsResourceReferenceByTarResourcesPlainArgs(
            targetResources = targetResources,
        )
}
