@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExperimentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property experimentName The Experiment identifier associated with the Experiment
 * @property profileName The Profile identifier associated with the Tenant and Partner
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetExperimentPlainArgs(
    public val experimentName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExperimentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetExperimentPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExperimentPlainArgs.builder()
            .experimentName(experimentName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExperimentPlainArgs].
 */
@PulumiTagMarker
public class GetExperimentPlainArgsBuilder internal constructor() {
    private var experimentName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The Experiment identifier associated with the Experiment
     */
    @JvmName("qmvxjswmdfguvigq")
    public suspend fun experimentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.experimentName = mapped
    }

    /**
     * @param value The Profile identifier associated with the Tenant and Partner
     */
    @JvmName("yvodrintxckupqnp")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("dvofkgujdnxaprjx")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExperimentPlainArgs = GetExperimentPlainArgs(
        experimentName = experimentName ?: throw PulumiNullFieldException("experimentName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
