@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property circuitName The name of express route circuit.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteCircuitPlainArgs(
    public val circuitName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteCircuitPlainArgs.builder()
            .circuitName(circuitName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteCircuitPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteCircuitPlainArgsBuilder internal constructor() {
    private var circuitName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of express route circuit.
     */
    @JvmName("nvlqwhwaioitrpiv")
    public suspend fun circuitName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.circuitName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("gfyqjbejentrjltl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteCircuitPlainArgs = GetExpressRouteCircuitPlainArgs(
        circuitName = circuitName ?: throw PulumiNullFieldException("circuitName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
