@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetExpressRouteGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expressRouteGatewayName The name of the ExpressRoute gateway.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetExpressRouteGatewayPlainArgs(
    public val expressRouteGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetExpressRouteGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetExpressRouteGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetExpressRouteGatewayPlainArgs.builder()
            .expressRouteGatewayName(expressRouteGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetExpressRouteGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetExpressRouteGatewayPlainArgsBuilder internal constructor() {
    private var expressRouteGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the ExpressRoute gateway.
     */
    @JvmName("axygiyamqwbxtpav")
    public suspend fun expressRouteGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.expressRouteGatewayName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nfbxmrowqsyqocjj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetExpressRouteGatewayPlainArgs = GetExpressRouteGatewayPlainArgs(
        expressRouteGatewayName = expressRouteGatewayName ?: throw
            PulumiNullFieldException("expressRouteGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
