@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleCollectionGroupPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property firewallPolicyName The name of the Firewall Policy.
 * @property resourceGroupName The name of the resource group.
 * @property ruleCollectionGroupName The name of the FirewallPolicyRuleCollectionGroup.
 */
public data class GetFirewallPolicyRuleCollectionGroupPlainArgs(
    public val firewallPolicyName: String,
    public val resourceGroupName: String,
    public val ruleCollectionGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleCollectionGroupPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleCollectionGroupPlainArgs =
        com.pulumi.azurenative.network.inputs.GetFirewallPolicyRuleCollectionGroupPlainArgs.builder()
            .firewallPolicyName(firewallPolicyName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .ruleCollectionGroupName(ruleCollectionGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFirewallPolicyRuleCollectionGroupPlainArgs].
 */
@PulumiTagMarker
public class GetFirewallPolicyRuleCollectionGroupPlainArgsBuilder internal constructor() {
    private var firewallPolicyName: String? = null

    private var resourceGroupName: String? = null

    private var ruleCollectionGroupName: String? = null

    /**
     * @param value The name of the Firewall Policy.
     */
    @JvmName("ndygxqogavprxniy")
    public suspend fun firewallPolicyName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.firewallPolicyName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("hctcoyshjtvdaltk")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the FirewallPolicyRuleCollectionGroup.
     */
    @JvmName("ilyxuwfhkvyhhvjr")
    public suspend fun ruleCollectionGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ruleCollectionGroupName = mapped
    }

    internal fun build(): GetFirewallPolicyRuleCollectionGroupPlainArgs =
        GetFirewallPolicyRuleCollectionGroupPlainArgs(
            firewallPolicyName = firewallPolicyName ?: throw PulumiNullFieldException("firewallPolicyName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            ruleCollectionGroupName = ruleCollectionGroupName ?: throw
                PulumiNullFieldException("ruleCollectionGroupName"),
        )
}
