@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetFrontDoorPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frontDoorName Name of the Front Door which is globally unique.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 */
public data class GetFrontDoorPlainArgs(
    public val frontDoorName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetFrontDoorPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetFrontDoorPlainArgs =
        com.pulumi.azurenative.network.inputs.GetFrontDoorPlainArgs.builder()
            .frontDoorName(frontDoorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFrontDoorPlainArgs].
 */
@PulumiTagMarker
public class GetFrontDoorPlainArgsBuilder internal constructor() {
    private var frontDoorName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("gytlqlvlhjksdyrk")
    public suspend fun frontDoorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frontDoorName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("qsjwoplyxchihukh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFrontDoorPlainArgs = GetFrontDoorPlainArgs(
        frontDoorName = frontDoorName ?: throw PulumiNullFieldException("frontDoorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
