@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetInboundNatRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property inboundNatRuleName The name of the inbound NAT rule.
 * @property loadBalancerName The name of the load balancer.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetInboundNatRulePlainArgs(
    public val expand: String? = null,
    public val inboundNatRuleName: String,
    public val loadBalancerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetInboundNatRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetInboundNatRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetInboundNatRulePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .inboundNatRuleName(inboundNatRuleName.let({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInboundNatRulePlainArgs].
 */
@PulumiTagMarker
public class GetInboundNatRulePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var inboundNatRuleName: String? = null

    private var loadBalancerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("wwxormpyjmuegbfr")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the inbound NAT rule.
     */
    @JvmName("otqeukibwixvuewf")
    public suspend fun inboundNatRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.inboundNatRuleName = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("rddmtvvjpbmijtpc")
    public suspend fun loadBalancerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ndoadkyvseocjlxo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInboundNatRulePlainArgs = GetInboundNatRulePlainArgs(
        expand = expand,
        inboundNatRuleName = inboundNatRuleName ?: throw PulumiNullFieldException("inboundNatRuleName"),
        loadBalancerName = loadBalancerName ?: throw PulumiNullFieldException("loadBalancerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
