@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetInterfaceEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property interfaceEndpointName The name of the interface endpoint.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetInterfaceEndpointPlainArgs(
    public val expand: String? = null,
    public val interfaceEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetInterfaceEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetInterfaceEndpointPlainArgs =
        com.pulumi.azurenative.network.inputs.GetInterfaceEndpointPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .interfaceEndpointName(interfaceEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetInterfaceEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetInterfaceEndpointPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var interfaceEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("epihflkguniylicy")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the interface endpoint.
     */
    @JvmName("wcpcvvdjpbjrykvg")
    public suspend fun interfaceEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.interfaceEndpointName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("phtxjwveyalriayl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetInterfaceEndpointPlainArgs = GetInterfaceEndpointPlainArgs(
        expand = expand,
        interfaceEndpointName = interfaceEndpointName ?: throw
            PulumiNullFieldException("interfaceEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
