@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetLoadBalancerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property loadBalancerName The name of the load balancer.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetLoadBalancerPlainArgs(
    public val expand: String? = null,
    public val loadBalancerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetLoadBalancerPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetLoadBalancerPlainArgs =
        com.pulumi.azurenative.network.inputs.GetLoadBalancerPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .loadBalancerName(loadBalancerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetLoadBalancerPlainArgs].
 */
@PulumiTagMarker
public class GetLoadBalancerPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var loadBalancerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("jdqhqmalcuidgmdb")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the load balancer.
     */
    @JvmName("rvsbxteixpyvodtk")
    public suspend fun loadBalancerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.loadBalancerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("taayoyijpputglfo")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetLoadBalancerPlainArgs = GetLoadBalancerPlainArgs(
        expand = expand,
        loadBalancerName = loadBalancerName ?: throw PulumiNullFieldException("loadBalancerName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
