@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNatGatewayPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property natGatewayName The name of the nat gateway.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNatGatewayPlainArgs(
    public val expand: String? = null,
    public val natGatewayName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNatGatewayPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNatGatewayPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNatGatewayPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .natGatewayName(natGatewayName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNatGatewayPlainArgs].
 */
@PulumiTagMarker
public class GetNatGatewayPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var natGatewayName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("bwnmhtjunwcelhkg")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the nat gateway.
     */
    @JvmName("puplotktjrwevkev")
    public suspend fun natGatewayName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.natGatewayName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("nlicnrhyasnsmkrq")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNatGatewayPlainArgs = GetNatGatewayPlainArgs(
        expand = expand,
        natGatewayName = natGatewayName ?: throw PulumiNullFieldException("natGatewayName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
