@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkInterfacePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property networkInterfaceName The name of the network interface.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkInterfacePlainArgs(
    public val expand: String? = null,
    public val networkInterfaceName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkInterfacePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkInterfacePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkInterfacePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .networkInterfaceName(networkInterfaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkInterfacePlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfacePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var networkInterfaceName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("ffbdowawalkyjmqn")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the network interface.
     */
    @JvmName("yedjkuixpfisdbbs")
    public suspend fun networkInterfaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("jsvofgpqksluqjni")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkInterfacePlainArgs = GetNetworkInterfacePlainArgs(
        expand = expand,
        networkInterfaceName = networkInterfaceName ?: throw
            PulumiNullFieldException("networkInterfaceName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
