@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkInterfaceTapConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkInterfaceName The name of the network interface.
 * @property resourceGroupName The name of the resource group.
 * @property tapConfigurationName The name of the tap configuration.
 */
public data class GetNetworkInterfaceTapConfigurationPlainArgs(
    public val networkInterfaceName: String,
    public val resourceGroupName: String,
    public val tapConfigurationName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkInterfaceTapConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkInterfaceTapConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkInterfaceTapConfigurationPlainArgs.builder()
            .networkInterfaceName(networkInterfaceName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .tapConfigurationName(tapConfigurationName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkInterfaceTapConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkInterfaceTapConfigurationPlainArgsBuilder internal constructor() {
    private var networkInterfaceName: String? = null

    private var resourceGroupName: String? = null

    private var tapConfigurationName: String? = null

    /**
     * @param value The name of the network interface.
     */
    @JvmName("akbpytwfkfagcfpd")
    public suspend fun networkInterfaceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkInterfaceName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("flabwwtynfoihigi")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the tap configuration.
     */
    @JvmName("hjpdmbfmdxnnsfdq")
    public suspend fun tapConfigurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tapConfigurationName = mapped
    }

    internal fun build(): GetNetworkInterfaceTapConfigurationPlainArgs =
        GetNetworkInterfaceTapConfigurationPlainArgs(
            networkInterfaceName = networkInterfaceName ?: throw
                PulumiNullFieldException("networkInterfaceName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            tapConfigurationName = tapConfigurationName ?: throw
                PulumiNullFieldException("tapConfigurationName"),
        )
}
