@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNetworkWatcherPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkWatcherName The name of the network watcher.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNetworkWatcherPlainArgs(
    public val networkWatcherName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNetworkWatcherPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNetworkWatcherPlainArgs =
        com.pulumi.azurenative.network.inputs.GetNetworkWatcherPlainArgs.builder()
            .networkWatcherName(networkWatcherName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNetworkWatcherPlainArgs].
 */
@PulumiTagMarker
public class GetNetworkWatcherPlainArgsBuilder internal constructor() {
    private var networkWatcherName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network watcher.
     */
    @JvmName("fcnrgatagjaicuor")
    public suspend fun networkWatcherName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkWatcherName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("utrrcofisrnlgsky")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNetworkWatcherPlainArgs = GetNetworkWatcherPlainArgs(
        networkWatcherName = networkWatcherName ?: throw PulumiNullFieldException("networkWatcherName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
