@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNspAccessRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessRuleName The name of the NSP access rule.
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property profileName The name of the NSP profile.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNspAccessRulePlainArgs(
    public val accessRuleName: String,
    public val networkSecurityPerimeterName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNspAccessRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNspAccessRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNspAccessRulePlainArgs.builder()
            .accessRuleName(accessRuleName.let({ args0 -> args0 }))
            .networkSecurityPerimeterName(networkSecurityPerimeterName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNspAccessRulePlainArgs].
 */
@PulumiTagMarker
public class GetNspAccessRulePlainArgsBuilder internal constructor() {
    private var accessRuleName: String? = null

    private var networkSecurityPerimeterName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the NSP access rule.
     */
    @JvmName("oliadbfwrxpakmwu")
    public suspend fun accessRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.accessRuleName = mapped
    }

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("fbypqyrlbmyykacw")
    public suspend fun networkSecurityPerimeterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the NSP profile.
     */
    @JvmName("kjtuwrhkuaaqmvts")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("qdcuoileahqgrkqh")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNspAccessRulePlainArgs = GetNspAccessRulePlainArgs(
        accessRuleName = accessRuleName ?: throw PulumiNullFieldException("accessRuleName"),
        networkSecurityPerimeterName = networkSecurityPerimeterName ?: throw
            PulumiNullFieldException("networkSecurityPerimeterName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
