@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetNspProfilePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkSecurityPerimeterName The name of the network security perimeter.
 * @property profileName The name of the NSP profile.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetNspProfilePlainArgs(
    public val networkSecurityPerimeterName: String,
    public val profileName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetNspProfilePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetNspProfilePlainArgs =
        com.pulumi.azurenative.network.inputs.GetNspProfilePlainArgs.builder()
            .networkSecurityPerimeterName(networkSecurityPerimeterName.let({ args0 -> args0 }))
            .profileName(profileName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetNspProfilePlainArgs].
 */
@PulumiTagMarker
public class GetNspProfilePlainArgsBuilder internal constructor() {
    private var networkSecurityPerimeterName: String? = null

    private var profileName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network security perimeter.
     */
    @JvmName("tkmphswucwexcvts")
    public suspend fun networkSecurityPerimeterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityPerimeterName = mapped
    }

    /**
     * @param value The name of the NSP profile.
     */
    @JvmName("yaovpmmtegyorvym")
    public suspend fun profileName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.profileName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("wuydxtecicvehapv")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetNspProfilePlainArgs = GetNspProfilePlainArgs(
        networkSecurityPerimeterName = networkSecurityPerimeterName ?: throw
            PulumiNullFieldException("networkSecurityPerimeterName"),
        profileName = profileName ?: throw PulumiNullFieldException("profileName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
