@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPrivateEndpointPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property privateEndpointName The name of the private endpoint.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPrivateEndpointPlainArgs(
    public val expand: String? = null,
    public val privateEndpointName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPrivateEndpointPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPrivateEndpointPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPrivateEndpointPlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .privateEndpointName(privateEndpointName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateEndpointPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateEndpointPlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var privateEndpointName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("uevjtupkjumgdjsi")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the private endpoint.
     */
    @JvmName("uutsigioylpplgms")
    public suspend fun privateEndpointName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateEndpointName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("cjxqdwtgbnqsqlon")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateEndpointPlainArgs = GetPrivateEndpointPlainArgs(
        expand = expand,
        privateEndpointName = privateEndpointName ?: throw PulumiNullFieldException("privateEndpointName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
