@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetPrivateRecordSetPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property privateZoneName The name of the Private DNS zone (without a terminating dot).
 * @property recordType The type of DNS record in this record set.
 * @property relativeRecordSetName The name of the record set, relative to the name of the zone.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetPrivateRecordSetPlainArgs(
    public val privateZoneName: String,
    public val recordType: String,
    public val relativeRecordSetName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetPrivateRecordSetPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetPrivateRecordSetPlainArgs =
        com.pulumi.azurenative.network.inputs.GetPrivateRecordSetPlainArgs.builder()
            .privateZoneName(privateZoneName.let({ args0 -> args0 }))
            .recordType(recordType.let({ args0 -> args0 }))
            .relativeRecordSetName(relativeRecordSetName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPrivateRecordSetPlainArgs].
 */
@PulumiTagMarker
public class GetPrivateRecordSetPlainArgsBuilder internal constructor() {
    private var privateZoneName: String? = null

    private var recordType: String? = null

    private var relativeRecordSetName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the Private DNS zone (without a terminating dot).
     */
    @JvmName("fivovlcdnrfodloh")
    public suspend fun privateZoneName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.privateZoneName = mapped
    }

    /**
     * @param value The type of DNS record in this record set.
     */
    @JvmName("oakokwsotvutbyhr")
    public suspend fun recordType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.recordType = mapped
    }

    /**
     * @param value The name of the record set, relative to the name of the zone.
     */
    @JvmName("wddmjofmfietbrrd")
    public suspend fun relativeRecordSetName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.relativeRecordSetName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("kcyonadtkfguguyt")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPrivateRecordSetPlainArgs = GetPrivateRecordSetPlainArgs(
        privateZoneName = privateZoneName ?: throw PulumiNullFieldException("privateZoneName"),
        recordType = recordType ?: throw PulumiNullFieldException("recordType"),
        relativeRecordSetName = relativeRecordSetName ?: throw
            PulumiNullFieldException("relativeRecordSetName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
