@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRoutePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property routeName The name of the route.
 * @property routeTableName The name of the route table.
 */
public data class GetRoutePlainArgs(
    public val resourceGroupName: String,
    public val routeName: String,
    public val routeTableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRoutePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRoutePlainArgs =
        com.pulumi.azurenative.network.inputs.GetRoutePlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeName(routeName.let({ args0 -> args0 }))
            .routeTableName(routeTableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoutePlainArgs].
 */
@PulumiTagMarker
public class GetRoutePlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var routeName: String? = null

    private var routeTableName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ddkitxknjyetwxia")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route.
     */
    @JvmName("hrpgvtwbgfpttfxp")
    public suspend fun routeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeName = mapped
    }

    /**
     * @param value The name of the route table.
     */
    @JvmName("njmcotixngrvvieb")
    public suspend fun routeTableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeTableName = mapped
    }

    internal fun build(): GetRoutePlainArgs = GetRoutePlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeName = routeName ?: throw PulumiNullFieldException("routeName"),
        routeTableName = routeTableName ?: throw PulumiNullFieldException("routeTableName"),
    )
}
