@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRouteTablePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property expand Expands referenced resources.
 * @property resourceGroupName The name of the resource group.
 * @property routeTableName The name of the route table.
 */
public data class GetRouteTablePlainArgs(
    public val expand: String? = null,
    public val resourceGroupName: String,
    public val routeTableName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRouteTablePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRouteTablePlainArgs =
        com.pulumi.azurenative.network.inputs.GetRouteTablePlainArgs.builder()
            .expand(expand?.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routeTableName(routeTableName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRouteTablePlainArgs].
 */
@PulumiTagMarker
public class GetRouteTablePlainArgsBuilder internal constructor() {
    private var expand: String? = null

    private var resourceGroupName: String? = null

    private var routeTableName: String? = null

    /**
     * @param value Expands referenced resources.
     */
    @JvmName("loywpegfdkkdamel")
    public suspend fun expand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.expand = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("ohgxwxcbwuiosumb")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the route table.
     */
    @JvmName("dtojvecjgslnrfxo")
    public suspend fun routeTableName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routeTableName = mapped
    }

    internal fun build(): GetRouteTablePlainArgs = GetRouteTablePlainArgs(
        expand = expand,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routeTableName = routeTableName ?: throw PulumiNullFieldException("routeTableName"),
    )
}
