@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRoutingIntentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The resource group name of the RoutingIntent.
 * @property routingIntentName The name of the RoutingIntent.
 * @property virtualHubName The name of the VirtualHub.
 */
public data class GetRoutingIntentPlainArgs(
    public val resourceGroupName: String,
    public val routingIntentName: String,
    public val virtualHubName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRoutingIntentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRoutingIntentPlainArgs =
        com.pulumi.azurenative.network.inputs.GetRoutingIntentPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .routingIntentName(routingIntentName.let({ args0 -> args0 }))
            .virtualHubName(virtualHubName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRoutingIntentPlainArgs].
 */
@PulumiTagMarker
public class GetRoutingIntentPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var routingIntentName: String? = null

    private var virtualHubName: String? = null

    /**
     * @param value The resource group name of the RoutingIntent.
     */
    @JvmName("mteckhdmrjxpkrfu")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the RoutingIntent.
     */
    @JvmName("mdtbycyiplsyixoi")
    public suspend fun routingIntentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.routingIntentName = mapped
    }

    /**
     * @param value The name of the VirtualHub.
     */
    @JvmName("vikcdydfgjtxwmbt")
    public suspend fun virtualHubName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.virtualHubName = mapped
    }

    internal fun build(): GetRoutingIntentPlainArgs = GetRoutingIntentPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        routingIntentName = routingIntentName ?: throw PulumiNullFieldException("routingIntentName"),
        virtualHubName = virtualHubName ?: throw PulumiNullFieldException("virtualHubName"),
    )
}
