@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetRulesEnginePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property frontDoorName Name of the Front Door which is globally unique.
 * @property resourceGroupName Name of the Resource group within the Azure subscription.
 * @property rulesEngineName Name of the Rules Engine which is unique within the Front Door.
 */
public data class GetRulesEnginePlainArgs(
    public val frontDoorName: String,
    public val resourceGroupName: String,
    public val rulesEngineName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetRulesEnginePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetRulesEnginePlainArgs =
        com.pulumi.azurenative.network.inputs.GetRulesEnginePlainArgs.builder()
            .frontDoorName(frontDoorName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .rulesEngineName(rulesEngineName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetRulesEnginePlainArgs].
 */
@PulumiTagMarker
public class GetRulesEnginePlainArgsBuilder internal constructor() {
    private var frontDoorName: String? = null

    private var resourceGroupName: String? = null

    private var rulesEngineName: String? = null

    /**
     * @param value Name of the Front Door which is globally unique.
     */
    @JvmName("ekqgrqjcglltxgxy")
    public suspend fun frontDoorName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.frontDoorName = mapped
    }

    /**
     * @param value Name of the Resource group within the Azure subscription.
     */
    @JvmName("rlusgfpjucyeiaop")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value Name of the Rules Engine which is unique within the Front Door.
     */
    @JvmName("cgknhvgdhneokdem")
    public suspend fun rulesEngineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.rulesEngineName = mapped
    }

    internal fun build(): GetRulesEnginePlainArgs = GetRulesEnginePlainArgs(
        frontDoorName = frontDoorName ?: throw PulumiNullFieldException("frontDoorName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        rulesEngineName = rulesEngineName ?: throw PulumiNullFieldException("rulesEngineName"),
    )
}
