@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetSecurityAdminConfigurationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property configurationName The name of the network manager Security Configuration.
 * @property networkManagerName The name of the network manager.
 * @property resourceGroupName The name of the resource group.
 */
public data class GetSecurityAdminConfigurationPlainArgs(
    public val configurationName: String,
    public val networkManagerName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetSecurityAdminConfigurationPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetSecurityAdminConfigurationPlainArgs =
        com.pulumi.azurenative.network.inputs.GetSecurityAdminConfigurationPlainArgs.builder()
            .configurationName(configurationName.let({ args0 -> args0 }))
            .networkManagerName(networkManagerName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityAdminConfigurationPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityAdminConfigurationPlainArgsBuilder internal constructor() {
    private var configurationName: String? = null

    private var networkManagerName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The name of the network manager Security Configuration.
     */
    @JvmName("vqwlcuyieaddfsur")
    public suspend fun configurationName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.configurationName = mapped
    }

    /**
     * @param value The name of the network manager.
     */
    @JvmName("jwxoeswvmunkerjo")
    public suspend fun networkManagerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkManagerName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("pawgeqnwsynwujqa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetSecurityAdminConfigurationPlainArgs =
        GetSecurityAdminConfigurationPlainArgs(
            configurationName = configurationName ?: throw PulumiNullFieldException("configurationName"),
            networkManagerName = networkManagerName ?: throw PulumiNullFieldException("networkManagerName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
