@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetSecurityPartnerProviderPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property resourceGroupName The name of the resource group.
 * @property securityPartnerProviderName The name of the Security Partner Provider.
 */
public data class GetSecurityPartnerProviderPlainArgs(
    public val resourceGroupName: String,
    public val securityPartnerProviderName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetSecurityPartnerProviderPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetSecurityPartnerProviderPlainArgs =
        com.pulumi.azurenative.network.inputs.GetSecurityPartnerProviderPlainArgs.builder()
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityPartnerProviderName(securityPartnerProviderName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityPartnerProviderPlainArgs].
 */
@PulumiTagMarker
public class GetSecurityPartnerProviderPlainArgsBuilder internal constructor() {
    private var resourceGroupName: String? = null

    private var securityPartnerProviderName: String? = null

    /**
     * @param value The name of the resource group.
     */
    @JvmName("arbaiijenrirjmyj")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the Security Partner Provider.
     */
    @JvmName("hnrurdpqgslfnjxm")
    public suspend fun securityPartnerProviderName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityPartnerProviderName = mapped
    }

    internal fun build(): GetSecurityPartnerProviderPlainArgs = GetSecurityPartnerProviderPlainArgs(
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityPartnerProviderName = securityPartnerProviderName ?: throw
            PulumiNullFieldException("securityPartnerProviderName"),
    )
}
