@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.network.kotlin.inputs

import com.pulumi.azurenative.network.inputs.GetSecurityRulePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property networkSecurityGroupName The name of the network security group.
 * @property resourceGroupName The name of the resource group.
 * @property securityRuleName The name of the security rule.
 */
public data class GetSecurityRulePlainArgs(
    public val networkSecurityGroupName: String,
    public val resourceGroupName: String,
    public val securityRuleName: String,
) : ConvertibleToJava<com.pulumi.azurenative.network.inputs.GetSecurityRulePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.network.inputs.GetSecurityRulePlainArgs =
        com.pulumi.azurenative.network.inputs.GetSecurityRulePlainArgs.builder()
            .networkSecurityGroupName(networkSecurityGroupName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .securityRuleName(securityRuleName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSecurityRulePlainArgs].
 */
@PulumiTagMarker
public class GetSecurityRulePlainArgsBuilder internal constructor() {
    private var networkSecurityGroupName: String? = null

    private var resourceGroupName: String? = null

    private var securityRuleName: String? = null

    /**
     * @param value The name of the network security group.
     */
    @JvmName("qgosvqbufohkxfok")
    public suspend fun networkSecurityGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.networkSecurityGroupName = mapped
    }

    /**
     * @param value The name of the resource group.
     */
    @JvmName("iepmmupxmlmjcfaa")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the security rule.
     */
    @JvmName("kidphvbhtjnyrsbv")
    public suspend fun securityRuleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.securityRuleName = mapped
    }

    internal fun build(): GetSecurityRulePlainArgs = GetSecurityRulePlainArgs(
        networkSecurityGroupName = networkSecurityGroupName ?: throw
            PulumiNullFieldException("networkSecurityGroupName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        securityRuleName = securityRuleName ?: throw PulumiNullFieldException("securityRuleName"),
    )
}
